$ENGINE=VBSCRIPT
'********************************************************
'* * Description:
'* Computes the Angle and Change in Angle between Two Vectors Defined by Selected Nodes.
'* To use Angle_Between_Two_Vectors.vbs select four nodes first.
'* The first vector is defined as from the first selected node to the second.
'* The second vector is defined from the third selected node to the fourth.  
'* These vectors are normalised and output to the text window.
'* The angle between the vectors for the original mesh, for the deformed mesh and 
'* the change in angle is also given in the Text Output window.
'* * History
'* Updated 27/02/2013
'********************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH*
'* IS NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED  *
'* ON AN AS IS BASIS FOR DEMONSTRATION PURPOSES.        *
'********************************************************
Set selectionSet = getSelection()
nObjects = selectionSet.count("node")

If nObjects = 4 Then

	msgbox "Four nodes selected"
	set tw=gettextwindow()
	text = "Calculating vectors from selected nodes..."
	tw.writeLine(text)
	node =  selectionSet.getObjects("node")
'get undeformed coordinates of node 1
	set node1 = node(0)
	X1 = node1.getX()
	Y1 = node1.getY()
	Z1 = node1.getZ()
'get undeformed coordinates of node 2
	set node2 = node(1)
	X2 = node2.getX()
	Y2= node2.getY()
	Z2 = node2.getZ()
'get deformed coordinates of node 1
	DX1 = node1.getDeformedX()
	DY1 = node1.getDeformedY()
	DZ1 = node1.getDeformedZ()
'get deformed coordinates of node 2
	DX2 = node2.getDeformedX()
	DY2 = node2.getDeformedY()
	DZ2 = node2.getDeformedZ()
'************************************ second set line ****************************************
'get undeformed coordinates of node 3
	set node3 = node(2)
	X3 = node3.getX()
	Y3 = node3.getY()
	Z3 = node3.getZ()
'get undeformed coordinates of node 4
	set node4 = node(3)
	X4 = node4.getX()
	Y4= node4.getY()
	Z4 = node4.getZ()
'get deformed coordinates of node 3
'	  tw.writeLine("deformed coordinates of node 3")
	DX3 = node3.getDeformedX()
	DY3 = node3.getDeformedY()
	DZ3 = node3.getDeformedZ()
'get deformed coordinates of node 4
	DX4 = node4.getDeformedX()
	DY4 = node4.getDeformedY()
	DZ4 = node4.getDeformedZ()
'************************************ convert node coordinates to vector form ****************************************
'vector form V1
XV1 = X2 - X1
YV1 = Y2 - Y1
ZV1 = Z2 - Z1
'vector form V2
XV2 = X4 - X3
YV2 = Y4 - Y3
ZV2 = Z4 - Z3
'normalized vector 1 and 2
V1length = ((XV1)^2+(YV1)^2+(ZV1)^2)^(1/2)
V2length = ((XV2)^2+(YV2)^2+(ZV2)^2)^(1/2)
XV1n = XV1/V1length
YV1n = YV1/V1length
ZV1n = ZV1/V1length
XV2n = XV2/V2length
YV2n = YV2/V2length
ZV2n = ZV2/V2length

        text = "Normalised Vector 1 for the original undeformed mesh = (" & XV1n & "," & YV1n &"," & ZV1n & ")"
        tw.writeLine(text)
	text = "Normalised Vector 2 for the original undeformed mesh = (" & XV2n & "," & YV2n &"," & ZV2n & ")"
        tw.writeLine(text)
'************************************ convert deformed node coordinates to vector form ****************************************
'vector form V1
DXV1 = DX2 - DX1
DYV1 = DY2 - DY1
DZV1 = DZ2 - DZ1
'vector form V2
DXV2 = DX4 - DX3
DYV2 = DY4 - DY3
DZV2 = DZ4 - DZ3
'normalized vector 1 and 2
DV1length = ((DXV1)^2+(DYV1)^2+(DZV1)^2)^(1/2)
DV2length = ((DXV2)^2+(DYV2)^2+(DZV2)^2)^(1/2)
DXV1n = DXV1/DV1length
DYV1n = DYV1/DV1length
DZV1n = DZV1/DV1length
DXV2n = DXV2/DV2length
DYV2n = DYV2/DV2length
DZV2n = DZV2/DV2length

        text = "Normalised Vector 1 for the deformed mesh = (" & DXV1n & "," & DYV1n &"," & DZV1n & ")"
        tw.writeLine(text)
	text = "Normalised Vector 2 for the deformed mesh = (" & DXV2n & "," & DYV2n &"," & DZV2n & ")"
        tw.writeLine(text)
'****************************************************************************************************
angle = (XV1n*XV2n+YV1n*YV2n+ZV1n*ZV2n)
Dangle = (DXV1n*DXV2n+DYV1n*DYV2n+DZV1n*DZV2n)
'****************************************************************************************************
'theta = acos(costheta)
expr = "acos(" & angle & ")"
err = ConvertFromString(expr,thetar)
theta1 = thetar * 180/3.141592653589793
        text = "Angle between vectors for the original undeformed mesh = " & theta1 & " degrees"
        tw.writeLine(text)
expr = "acos(" & Dangle & ")"
err = ConvertFromString(expr,thetar)
theta2 = thetar * 180/3.141592653589793
        text = "Angle between vectors for the deformed mesh = " & theta2 & " degrees"
        tw.writeLine(text)
'*****************************************************************************************************
	text = "Change in angle between vectors = "& theta2-theta1 & " degrees"
        tw.writeLine(text)
	text = "...Finished"
        tw.writeLine(text)
Else msgbox "PLEASE SELECT 4 NODES ONLY"

End If
