$ENGINE=VBSCRIPT
'
'*********************************************************************
'* Annotate_Line_Length.vbs                                          *
'* Created 2007                                                      *
'* Annotates selected lines with their length                        *
'*********************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS NOT      *
'* QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS IS BASIS    *
'* FOR DEMONSTRATION PURPOSES.                                       *
'*********************************************************************
'
' Number of decimal places required
dp = 4
' Get current selection object
Set sel = getSelection()
'
'Filter selection as an array of nodes
linearray = sel.getObjects("Line", "ALL")
'
' Loop selected lines to get length and anchor point and create annotation
For i = 0 To UBound(linearray)
'
'
' get line number and coordinates
      'Get the length of the line
      length  = linearray(i).getLineLength()
      'Get the coordinates of a position 40% along the line as an anchor point for annotation
      location = linearray(i).getInterpolatedPosition(0.4)
 
      'MsgBox "Line" & lnum & " , length=" & length & ", Anchor point: X=" & location(0) & ", Y=" & location(1) & ", Z=" & location(2)

      'Annotate line 40% along the line with length of the line
      set newText = database.createAnnotationText()
      call newText.setText(length)
      call newText.setAlignTop()
      call newText.setAlignLeft()
      call newText.setColour(0, 0, 0)
      call newText.setFont("Arial;140;Bold;NoItalic;NoUnderline;NoStrikeOut;0;")
      call newText.setRotation(0.0)
      call newText.fixToModel()
      call newText.setPosition(location(0), location(1), location(2))
      call newText.showInCurrentView()
      call view.insertAnnotationLayer()
      set newText = nothing

Next
Set linearray = Nothing
'
Set sel = Nothing
