$ENGINE=VBScript
'********************************************************
'* Aspect_Ratio_Plot.vbs Rev 1                          *
'* Created at 14:39 on Tuesday, April 12 2016           *
'* (C) FEA Ltd 2016                                     *
'* Aspect Ratio Plot                                    *
'********************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH*
'* IS NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED  *
'* ON AN AS IS BASIS FOR DEMONSTRATION PURPOSES.        *
'********************************************************
On Error Resume Next
' Define the name of the script
    Const NameOfScript = "Aspect Ratio Plot"
' Flush results column
    database.flushScriptedResults()
' Set a manual refresh
    setManualRefresh(1)
' Get text window object
    set tw = getTextWindow()
    tw.writeline("Calculating element aspect ratios...")
' Declare a dynamic array which will later be used for distances between element nodes
    Dim DistBetNodes()
' Declare a dynamic array which will later be used for element edge lengths between corner nodes for solid elements
    Dim EltEdgeLen()
' Initialise a flag 'groupcreated' as to whether a group is created for elements with an aspect ratio greater than 10:1
    groupcreated=0
' Initialise error number and error data variables
    ErrorNum = 0
    ErrorData = ""
' Creating an array of suitable surface mesh element types
    StblSrfcStrssMdlArray = Array("Axisymmetric Solid", "Plane Stress","Plane Strain", "Space Membrane", "Thin Plate", "Thick Plate", "Thin Shell", "Thick Shell")
' Set the UI name of the scripted results
    db.setScriptedResultsEntity("UserResults")
' check if anything is selected and if not select all visible
' Initialise a flag 'NothingSelected' as to whether the user made a selection prior to running the script or not
    NothingSelected=0
    IF selection.count("All") = 0 Then 
      call selection.Add("Element", "All")
      NothingSelected=1
    Else
      NothingSelected=0
    End If

' extract array of elements in the selection
    call database.options.setBoolean("associateDown", false)
    set tempSetA = newGeometrySet()
    set Selected = newGeometrySet()
    call tempSetA.add(selection)
    call tempSetA.addLOF("Elements")
    call Selected.remove("all")
    call Selected.add(tempSetA)
    set tempSetA = nothing
    selectedelts = Selected.getObjects("Elements", "All")
    set Selected = nothing
' Obtain an array of solid elements from the selection
    set tempSetA = newGeometrySet()
    Set Selected = newGeometrySet()
    call tempSetA.add(selectedelts)
    call tempSetA.keep("Solids")
    StblSldElts = tempSetA.getObjects("Elements", "All")
    call Selected.remove("all")
' Obtain an array of suitable surface mesh elements from the selection
    For i = 0 to UBound (StblSrfcStrssMdlArray)
      call tempSetA.remove("all")
      call tempSetA.add(selectedelts)
      call tempSetA.keep(StblSrfcStrssMdlArray(i))
      call Selected.add(tempSetA)
    Next
    StblSrfcElts = Selected.getObjects("Elements", "All")
    call tempSetA.remove("all")
    set tempSetA = nothing
' Provide a warning if there are no suitable solid elements nor suitable surface mesh elements in the selection and stop the script
    call Selected.add(StblSldElts)
    Suitableelements = Selected.getObjects("Elements", "All")
    If ubound(Suitableelements) = -1 Then Call QuitScript(1,0)
    set Selected = nothing

' Loop surface mesh elements
    For j = 0 to ubound(StblSrfcElts)
' Extract array of nodes for the current element
      eltnodes = StblSrfcElts(j).getNodes()
      eltnodenum = ubound(eltnodes)+1
' Calculate aspect ratio 
      ReDim DistBetNodes(eltnodenum-1)
      MaxDistBetNodes = 0
      MinDistBetNodes = 1E99
' Loop through nodes obtaining lengths between pairs
      For i = 0 to eltnodenum-1
        set nodeA = eltnodes(i)
        If i = 0 Then 
          set nodeB = eltnodes(eltnodenum-1)
        Else
          set nodeB = eltnodes(i-1)
        End If
        DistBetNodes(i) = DistBetTwoNodes(nodeA,nodeB)
' Compare the length between the current pair of nodes with the max and min found so far and change the max or min where the current length is more extreme
        If DistBetNodes(i) > MaxDistBetNodes Then MaxDistBetNodes = DistBetNodes(i)
        If DistBetNodes(i) < MinDistBetNodes Then MinDistBetNodes = DistBetNodes(i)
      Next
' Checks on the min and max element edge lengths here to trap any error due to zero values or extreme values
      If MaxDistBetNodes = 0 Then Call QuitScript(3,StblSrfcElts(j).getID())
      If MaxDistBetNodes > 1E6 Then Call QuitScript(4,StblSrfcElts(j).getID())
      If MinDistBetNodes > 1E6 Then Call QuitScript(5,StblSrfcElts(j).getID())
      If MinDistBetNodes < 1E-6 Then Call QuitScript(6,StblSrfcElts(j).getID())

' Calculate the aspect ratio between longest and shortest element edges/distances between nodes
      AREdges = MaxDistBetNodes/MinDistBetNodes
' Text Output warning for elements for aspect ratios greater than 10:1
      If AREdges > 10 Then 
' Create a group called "EltsAspRatGrtrThan10" for elements with an aspect ratio greater than 10:1
        If groupcreated=0 Then
          db.createEmptyGroup("EltsAspRatGrtrThan10")
          groupcreated=1
        Else
        End If
        tw.writeline("Element " & StblSrfcElts(j).getID() & " has an aspect ratio of " & AREdges & " which is greater than 10:1")
        call database.getGroupByName("EltsAspRatGrtrThan10").add("Element", StblSrfcElts(j))
      Else
      End If
' Could add in code here for the creation of a group of elements for aspect ratios greater than 10:1  
      set nodeA = nothing
      set nodeB = nothing
      Erase DistBetNodes
      set MaxDistBetNodes = nothing
      set MinDistBetNodes = nothing
' loop element nodes to set aspect ratio result
      For i = 0 to eltnodenum-1
          set node = eltnodes(i)
' set unaveraged nodal value for aspect ratio
      	Call StblSrfcElts(j).setNodeScriptedResults(node, AREdges, "AspectRatio(Edges)")
      Next
      set AREdges = nothing
      set eltnodes = nothing
      set eltnodenum = nothing
      set node = nothing
    Next

' Loop solid mesh elements
    For k = 0 to ubound(StblSldElts)
' extract array of nodes for the current element
      eltnodes = StblSldElts(k).getNodes()
      eltnodenum = ubound(eltnodes)+1
' Define the number of edge lengths between corner nodes based on the number of nodes the element has
      Select Case eltnodenum   
' TH4 elements
        Case 4
          lengthnum = 6
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(1))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(2))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(3))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(1),eltnodes(2))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(1),eltnodes(3))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(2),eltnodes(3))
' PN6 elements
        Case 6
          lengthnum = 9
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(1))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(2))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(3))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(1),eltnodes(2))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(1),eltnodes(4))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(2),eltnodes(5))
          EltEdgeLen(6) = DistBetTwoNodes(eltnodes(3),eltnodes(4))
          EltEdgeLen(7) = DistBetTwoNodes(eltnodes(3),eltnodes(5))
          EltEdgeLen(8) = DistBetTwoNodes(eltnodes(4),eltnodes(5))
' HX8 elements
        Case 8
          lengthnum = 12
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(1))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(3))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(4))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(1),eltnodes(2))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(1),eltnodes(5))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(2),eltnodes(3))
          EltEdgeLen(6) = DistBetTwoNodes(eltnodes(2),eltnodes(6))
          EltEdgeLen(7) = DistBetTwoNodes(eltnodes(3),eltnodes(7))
          EltEdgeLen(8) = DistBetTwoNodes(eltnodes(4),eltnodes(5))
          EltEdgeLen(9) = DistBetTwoNodes(eltnodes(4),eltnodes(7))
          EltEdgeLen(10) = DistBetTwoNodes(eltnodes(5),eltnodes(6))
          EltEdgeLen(11) = DistBetTwoNodes(eltnodes(6),eltnodes(7))
' TH10 elements
        Case 10 
          lengthnum = 6
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(2))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(4))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(9))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(2),eltnodes(4))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(2),eltnodes(9))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(4),eltnodes(9))
' PN12 elements
        Case 12
          lengthnum = 9
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(2))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(4))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(6))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(2),eltnodes(4))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(2),eltnodes(8))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(4),eltnodes(10))
          EltEdgeLen(6) = DistBetTwoNodes(eltnodes(6),eltnodes(8))
          EltEdgeLen(7) = DistBetTwoNodes(eltnodes(6),eltnodes(10))
          EltEdgeLen(8) = DistBetTwoNodes(eltnodes(8),eltnodes(10))
' PN15 elements
        Case 15
          lengthnum = 9
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(2))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(4))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(9))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(2),eltnodes(4))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(2),eltnodes(11))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(4),eltnodes(13))
          EltEdgeLen(6) = DistBetTwoNodes(eltnodes(9),eltnodes(11))
          EltEdgeLen(7) = DistBetTwoNodes(eltnodes(9),eltnodes(13))
          EltEdgeLen(8) = DistBetTwoNodes(eltnodes(11),eltnodes(13))
' HX16 elements
        Case 16
          lengthnum = 12
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(2))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(6))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(8))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(2),eltnodes(4))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(2),eltnodes(10))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(4),eltnodes(6))
          EltEdgeLen(6) = DistBetTwoNodes(eltnodes(4),eltnodes(12))
          EltEdgeLen(7) = DistBetTwoNodes(eltnodes(6),eltnodes(14))
          EltEdgeLen(8) = DistBetTwoNodes(eltnodes(8),eltnodes(10))
          EltEdgeLen(9) = DistBetTwoNodes(eltnodes(8),eltnodes(14))
          EltEdgeLen(10) = DistBetTwoNodes(eltnodes(10),eltnodes(12))
          EltEdgeLen(11) = DistBetTwoNodes(eltnodes(12),eltnodes(14))
' HX20 elements
        Case 20
          lengthnum = 12
          ReDim EltEdgeLen(lengthnum-1)
          EltEdgeLen(0) = DistBetTwoNodes(eltnodes(0),eltnodes(2))
          EltEdgeLen(1) = DistBetTwoNodes(eltnodes(0),eltnodes(6))
          EltEdgeLen(2) = DistBetTwoNodes(eltnodes(0),eltnodes(12))
          EltEdgeLen(3) = DistBetTwoNodes(eltnodes(2),eltnodes(4))
          EltEdgeLen(4) = DistBetTwoNodes(eltnodes(2),eltnodes(14))
          EltEdgeLen(5) = DistBetTwoNodes(eltnodes(4),eltnodes(6))
          EltEdgeLen(6) = DistBetTwoNodes(eltnodes(4),eltnodes(16))
          EltEdgeLen(7) = DistBetTwoNodes(eltnodes(6),eltnodes(18))
          EltEdgeLen(8) = DistBetTwoNodes(eltnodes(12),eltnodes(14))
          EltEdgeLen(9) = DistBetTwoNodes(eltnodes(14),eltnodes(16))
          EltEdgeLen(10) = DistBetTwoNodes(eltnodes(16),eltnodes(18))
          EltEdgeLen(11) = DistBetTwoNodes(eltnodes(12),eltnodes(18))
        Case Else 
          Call QuitScript(2,StblSldElts(k).getID())
      End Select

' Set min and max element edge lengths 
      MaxEltEdgeLen = 0
      MinEltEdgeLen = 1E99
' Loop through edge lengths to find min and max
      For l = 0 to lengthnum-1
        If EltEdgeLen(l) > MaxEltEdgeLen Then MaxEltEdgeLen = EltEdgeLen(l)
        If EltEdgeLen(l) < MinEltEdgeLen Then MinEltEdgeLen = EltEdgeLen(l)
      Next
' Checks on the min and max element edge lengths here to trap any error due to zero values or extreme values
      If MaxEltEdgeLen = 0 Then Call QuitScript(3,StblSldElts(k).getID())
      If MaxEltEdgeLen > 1E6 Then Call QuitScript(4,StblSldElts(k).getID())
      If MinEltEdgeLen > 1E6 Then Call QuitScript(5,StblSldElts(k).getID())
      If MinEltEdgeLen < 1E-6 Then Call QuitScript(6,StblSldElts(k).getID())

      AREdges = MaxEltEdgeLen/MinEltEdgeLen
' Text Output warning for elements for aspect ratios greater than 10:1
      If AREdges > 10 Then 
        If groupcreated=0 Then
' Create an empty group for elements with an aspect ration greater than 10
          db.createEmptyGroup("EltsAspRatGrtrThan10")
          groupcreated=1
        Else
        End If
        tw.writeline("Element " & StblSldElts(k).getID() & " has an aspect ratio of " & AREdges & " which is greater than 10:1")
        call database.getGroupByName("EltsAspRatGrtrThan10").add("Element", StblSldElts(k))
      Else
      End If
      set nodeA = nothing
      set nodeB = nothing
      Erase EltEdgeLen
      set MaxEltEdgeLen = nothing
      set MinEltEdgeLen = nothing
' loop element nodes to set aspect ratio result
      For i = 0 to eltnodenum-1
        set node = eltnodes(i)
        ' set unaveraged nodal value for aspect ratio
    	Call StblSldElts(k).setNodeScriptedResults(node, AREdges, "AspectRatio(Edges)")
      Next
      set AREdges = nothing
      set eltnodes = nothing
      set eltnodenum = nothing
      set node = nothing
      Set lengthnum = nothing
    Next

' Display contours of aspect ratio if the contours layer is present in the current view and values if a values layer is already present
    If view.existsContoursLayer() = 0 Then view.insertContoursLayer
    call view.contours.setResultsTransformNone()
    call view.contours.setResults("UserResults", "AspectRatio(Edges)")
    call view.contours.setShowSmoothed("elementNodal")
    call view.contours.setRangeAutoNumber(27)
    call view.contours.setSpecifyMaximum(false)
    call view.contours.setSpecifyMinimum(false)
    call view.contours().setVisible(true)
' Display values of aspect ratio if the values layer is present in the current view
    If view.existsValuesLayer() = 1 Then 
      call view.values.setResultsTransformNone()
      call view.values.setResults("UserResults", "AspectRatio(Edges)")
' Force unaveraged nodal values to be displayed
      call view.values.setShowAtElementNodes(true)
    Else
    End If
' Clear the selection if the user did not originally select anything, restore the automatic refresh and confirm that the script has finisihed
    If NothingSelected=1 Then call selection.remove("All")
    setManualRefresh(0)
    tw.writeline("...Completed.")
    tw.writeline("The Element aspect ratios calculated can be found under the entity 'User Results' and the component 'AspectRatio(Edges)'")
    tw.writeline("'AspectRatio(Edges)' results are only available as unaveraged nodal values or for unsmoothed Contour plots")
    If groupcreated=1 Then tw.writeline("A group with the name 'EltsAspRatGrtrThan10' has been created for all elements found to have an aspect ratio greater than 10:1")

'===============================================================================
Sub QuitScript(ErrorNum,ErrorData)
'*Purpose

' Provides the user with an error message before turning off manual refresh and stopping the script
'*Externals

' ErrorNum      -Integer identifying a particular error message to be displayed

' ErrorData       -Any data associated with the error to be given to the user, eg. the ID number of an item to which the error relates

'-------------------------------------------------------------------------------
    Select Case ErrorNum
      Case 1 
        msgbox "Error: The selection does not contain any suitable elements, nor features meshed with suitable elements", vbCritical + vbOKOnly, NameOfScript
      Case 2
        msgBox("Element " & ErrorData & " has a number of nodes that is not supported by this script"), vbCritical + vbOKOnly, NameOfScript
      Case 3
        msgBox("Element " & ErrorData & " has a maximum element edge length of zero"), vbCritical + vbOKOnly, NameOfScript
      Case 4
        msgBox("Element " & ErrorData & " has a maximum element edge length greater than 1E6"), vbCritical + vbOKOnly, NameOfScript
      Case 5
        msgBox("Element " & ErrorData & " has a minimum element edge length greater than 1E6"), vbCritical + vbOKOnly, NameOfScript
      Case 6
        msgBox("Element " & ErrorData & " has a minimum element edge length less than 1E-6"), vbCritical + vbOKOnly, NameOfScript
      Case Else 
        msgBox("The script was stopped"), vbCritical + vbOKOnly, NameOfScript 
    End Select
    database.flushScriptedResults()
    tw.writeline("...script terminated.")
    If view.existsContoursLayer() = 1 Then call view.contours().setVisible(false)
    setManualRefresh(0)
    StopScript
End Sub

'===============================================================================
Function DistBetTwoNodes(nodeA,nodeB)
'*Purpose

' Calculates the distance between two nodes
'*Externals

' nodeA       -first node object
' nodeB       -second node object
'-------------------------------------------------------------------------------
    DistBetTwoNodes = ((nodeA.getX()-nodeB.getX())^2 + (nodeA.getY()-nodeB.getY())^2 + (nodeA.getZ()-nodeB.getZ())^2)^(0.5)
End Function
