$ENGINE=VBScript
'**************************************************************
'* AssignLoad.vbs                                             *
'* Created 16th June 2010                                     *
'* Assigns a chosen load to all loadcases with a specified    *
'* range												      *
'**************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS   *
'* NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS  *
'* IS BASIS FOR DEMONSTRATION PURPOSES.                       *
'**************************************************************
'
'
call setCreationVersion("14.3-9")
Set txtWindow = getTextWindow()
Call Assignload()


Sub Assignload()

'Get an array of all loadcases
LCArr = db.getloadsets("loadcase", "ALL")
'Get an array of all load attributes
LoadArr = db.getattributes("loading", "ALL")

'Length of loadcase array
LenArr = ubound(LCArr)

'Default Load attribute ID, Start loadcase and End Loadcase 
DefLDID = LoadArr(0).getid()
DefStLC = LCArr(0).getid()
DefEndLC = LCArr(LenArr).getid()


'*** Define load attribue ID, loadcase range and loadcase increment for new assignment. 
LoadID = inputbox("Enter Load attribute ID to be assigned",,DefLDID)
If LoadID="" Then Exit Sub 			'process cancel button
LoadID = CInt(LoadID)				'convert string input to integer

'Check on validity of load ID
	If db.existsAttribute("loading", LoadID) = false Then 
	MsgBox ("Invalid load attribute ID entered")
	Exit Sub
	End If
	
StLC = inputbox ("Enter first loadcases number",,DefStLC)
If StLC="" Then Exit Sub 			'process cancel button
StLC = CInt(StLC)				'convert string input to integer

'Check on validity of start loadcase ID
	If db.existsLoadset(StLC) = false Then 
	MsgBox ("Invalid start loadcase ID entered")
	Exit Sub
	End If
	
EndLC = inputbox ("Enter last loadcase number",,DefEndLC)
If EndLC="" Then Exit Sub 			'process cancel button
EndLC = CInt(EndLC)					'convert string input to integer

'Check on validity of end loadcase ID	
	If db.existsLoadset(EndLC) = false Then 
	MsgBox ("Invalid end loadcase ID entered")
	Exit Sub
	End If
	
	If StLC >= EndLC Then 
	MsgBox ("Invalid loadcase IDs entered - end must be greater than start loadcase ID")
	Exit Sub
	End If


IncLC = inputbox ("If required, enter the desired increment between successive loadcases in the range",,1)
If IncLC="" Then Exit Sub 			'process cancel button
IncLC = CInt(IncLC)					'convert string input to integer

'Check on validity of loadcase increment
	If IncLC < 1 Or IncLC >= (EndLC-StLC) Then 
	MsgBox ("Invalid incremenent entered")
	Exit Sub
	End If



'Get loadcase name for chosen load attribute
LoadName = LoadArr(0).getname()
'msgbox LoadName


'Step through loadcase array until specified start loadcase ID is found
For i=0 To UBound(LCArr)
 		
'Get Loadcase ID for current count and update for increment
LCID = LCArr(i).getid()

	'Get current loadcase name
	'LCName = db.getloadset(LCID).getname()
	'msgbox LCName
	
'Check for first loadcase ID
if (LCID = StLC) Then
	
	'If start LC found, now step through in specified increments until end loadcase ID is found
	For j=0 To UBound(LCArr)-i Step IncLC
	
	LCID = LCArr(i+j).getid()
	
		if (LCID > EndLC) Then
			Exit For
			
		else
	
			txtWindow.writeline("Assignment to loadcase " & LCID & " : " & LCName)
			
			'set loadcase active so that load can be assigned in this loadcase
			call view.setActiveLoadset(LCID)
	
		call assignment.setAllDefaults()
	
			'Assign loading to current selection in current loadcase
			call database.getAttribute("Loading", LoadID).assignTo(selection, assignment)
		End if
			
	Next
	
Exit For

end If
next


set txtWindow = Nothing

End sub