$ENGINE=VBScript
'**************************************************************** 
'* CopyLoads.vbs                                                *
'* Created 29th June 2010                                       *
'* Copies specified loads assignments in the currently active   *
'* loadcase to a specified range of loadcases. NOTE THAT LOAD   *
'* FACTORS ARE NOT COPIED. i.e. ALL LOAD ASSIGNMENTS WILL BE    *
'* COPIED WITH A LOAD FACTOR OF 1.0 & Discrete laods are excluded							  *
'****************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS     *
'* NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS    *
'* IS BASIS FOR DEMONSTRATION PURPOSES.                         *
'****************************************************************
'
'
Dim txtWindow
Set txtWindow = getTextWindow()
txtwindow.writeline(VbCrLf)

call setCreationVersion("14.3-9")

canc = Msgbox ("NOTE: This script will not copy load factors associated with the load assignments. " & vbCrLf & "i.e. ALL COPIED LOAD ASSIGNMENTS WILL BE ASSIGNED WITH A LOAD FACTOR OF 1.0", vbOKCancel)	
if canc = 1 then 
Call CopyLoads()
end if


Sub CopyLoads()
	'Get current loadcase
	set currLC = view.getactiveloadset()
	
	' Call function (see below) to get an array of load attributes in the current loadcase
	LoadArr = GetLoadsInLC(currLC)
	
	'msgbox vartype(LoadArr)
	if vartype(LoadArr)=2 then			'Load Arr set to type 'Null'
	Msgbox ("No load assignments in current loadcase")
	exit sub
	end if
	
	' Call function (see below) to obtain inputs from user
	canc = GetInputs(LoadArr, StLC,  EndLC,  IncLC)
	
	if canc = -1 then exit sub			'invalid input or cancel button clicked in GetInputs function

	'Cycle through loads attributes to copy each one to spedified range of loadcases
	For i = 0 to ubound(LoadArr)
	
				'Check for patch loads
				LoadType = LoadArr(i).getsubtype()
				LoadName = LoadArr(i).getName()
				LoadID = LoadArr(i).getID()
				'msgbox loadtype
					
				if strcomp(LoadType, "point",1)=0 or strcomp(LoadType, "patch",1)=0 then
					msgbox("Load " & LoadID & " is a discrete load." & VbCrLf & _
					"Discrete point or patch loads cannot be copied using this script. Please see the attached script description file for details")
				else
					
					' Obtain the assigned features for each load
					call selection.remove("All")
					call selection.add("Loading", LoadArr(i))

					' Call function (see below) to assign each load to the specified range of loadcases
					Call Assignload(LoadArr(i),StLC,EndLC,IncLC,false)
				end if
	next

end sub



' ******************************************************************************
function GetInputs(byref LoadArr, byref StLC, byref EndLC, byref IncLC)
	GetInputs = 0 			' Set to -1 below to indicate error or cancel for outer subroutines

	LCArr = db.getloadsets("Loadcase", "All")

	'Length of loadcase array
	LenLCArr = ubound(LCArr)

	'Default Load attribute ID, Start loadcase and End Loadcase 
	DefLDID = "All"
	DefStLC = LCArr(0).getid()
	DefEndLC = LCArr(LenLCArr).getid()


	'*** Choose loadcase that you wish to assign. 
	LoadIDSt = inputbox("Enter Load attribute ID to be assigned (comma separated for multple)",,DefLDID)

			'process cancel button
			If LoadIDSt="" Then 		
				GetInputs = -1	
					'txtwindow.writeline("cancel pressed")
				Exit function 			
			end if
			
			
			If strcomp(LoadIDSt,"All",1)=0 Then
			' Use all loadcase IDs (already defined) so do nothing

			
			else		
			'Call function (see below) to convert comma seperated input into array of loadcase IDs
				LoadIDArr=NumStrToArray(LoadIDSt)
				
				
			'Redefine the array of load attributes as that defined by user 
				LenLDArr = ubound(LoadIDArr)
				ReDim LoadArr(LenLDArr)
				for i=0 to LenLDArr
					set LoadArr(i) = db.getAttribute("loading", LoadIDArr(i))
				next

				'Check on validity of load ID
				for i=0 to LenLDArr
					If not(db.existsAttribute("loading", LoadIDArr(i))) Then 
					MsgBox ("Load ID " & LoadIDArr(i) & " does not exist")
					GetInputs = -1	
					Exit function
					End If
				next
			end if

	'*** Define range for loadcases to assign load to 
	StLC = inputbox ("Enter first loadcases number",,DefStLC)

			'process cancel button
			If StLC="" Then 
				GetInputs = -1
				txtwindow.writeline("cancel pressed")
				Exit function 			
			end if
		
			
		StLC = CInt(StLC)				'convert string input to integer

			'Check on validity of start loadcase ID
				If not(db.existsLoadset(StLC)) Then 
				MsgBox ("Invalid start loadcase ID entered")
				GetInputs = -1
				Exit function
				End If
		
		EndLC = inputbox ("Enter last loadcases number",,DefEndLC)
		
			'process cancel button
			If EndLC="" Then 
				GetInputs = -1
				Exit function 			
			end if
			
		EndLC = CInt(EndLC)					'convert string input to integer

			'Check on validity of end loadcase ID	
				If not(db.existsLoadset(EndLC)) Then 
				MsgBox ("Invalid end loadcase ID entered")
				GetInputs = -1
				Exit function
				End If
				
				If StLC >= EndLC Then 
				MsgBox ("Invalid loadcase IDs entered - end must be greater than start loadcase ID")
				GetInputs = -1
				Exit function
				End If

	'*** Define increment for loop through loadcases 
	IncLC = inputbox ("If required, enter the desired increment between successive loadcases in the range",,1)
			If IncLC="" Then 
				GetInputs = -1
				Exit function 			
			end if
			
		IncLC = CInt(IncLC)					'convert string input to integer

			'Check on validity of loadcase increment
				If IncLC < 1 Or IncLC >= (EndLC-StLC) Then 
				MsgBox ("Invalid incremenent entered")
				GetInputs = -1
				Exit function
				End If
	
End function

' ******************************************************************************


Sub Assignload(LoadAtr,StLC,EndLC,IncLC,AssCurr)
	txtwindow.writeline(VbCrLf)
	'msgbox LoadAtr.getname()
	
	'Get current loadcase
	set currLC = view.getactiveloadset()

	'Get an array of all loadcases
	LCArr = db.getloadsets("loadcase", "ALL")

	'Step through loadcase array until specified start loadcase ID is found
	For i=0 To UBound(LCArr)
			
		'Get current Loadcase ID
			LCID = LCArr(i).getid()
		
		'Get current loadcase name
			LCName = LCArr(i).getname()
		
				
		'Check for first loadcase ID
			if (LCID = StLC) Then
			'If start LC found, now step through in specified increments until end loadcase ID is found
				
				For j=0 To UBound(LCArr)-i Step IncLC
				
				LCID = LCArr(i+j).getid()
				'msgbox "CurrID = " & currLC.getID & ", LCID = " & LCID
					if (LCID > EndLC) Then
						' reached last loadcase
						Exit For
						
					else
					
						if not(AssCurr) and (LCID = currLC.getID) then
						'"assign current" flag is false then do not assign to current loadcase - so do nothing
						'msgbox "LC " & LCID & " same as current"
						
						else
							LCName = db.getloadset(LCID).getname()
							txtWindow.writeline("Assignment to loadcase " & LCID & " : '" & LCName & "'")
							
							'set loadcase active so that load can be assigned in this loadcase
							call view.setActiveLoadset(LCID)
				
							call assignment.setAllDefaults()
				
							'Assign loading to current selection in current loadcase
							call LoadAtr.assignTo(selection, assignment)
						end if
					End if
					
			Next
			
		Exit For

		end If
	next

	view.setActiveLoadset(currLC)


End sub

' ******************************************************************************



function NumStrToArray(NumString)
	' Create array to store numbers in string
	dim NumArr()

	' Length of string
	strlen = len(NumString)
	'create empty string to store individual numbers
	num = ""
	' index in array
	n=0
		' counter for step through string
	i=1

	While i<=strlen
		' get individual characters in string
		chari = mid(NumString,i,1)
				
		if strcomp(chari, " ")=0 then 
		'do nothing, just step to next character
		
			elseif strcomp(chari, ",")=0 then
			'comma indicates end of number - store number in array 
				Redim preserve NumArr(n)
				'convert string to integer and put in array
				NumArr(n) = cint(num)
				'reset num string
				num = ""
				n = n + 1
			else
			' Concatenate character to end of number string
			num = num & chari
		end if
	i=i+1
	wend
	
	'store last number  in array
	Redim preserve NumArr(n)
	'convert string to integer and put in array
	NumArr(n) = cint(num)
	
	'reset num string
	num = ""

NumStrToArray = NumArr

end function


' ******************************************************************************

Function GetLoadsInLC(Loadcase)

	Dim LoadArr()
	'Array of loadcases initially zero length
	n=0
	ReDim LoadArr(n)
	
	'Get an array of assignments in the current loadcase	
	AsgnArr = Loadcase.getAssignments("load")

		'Only check loads that have assignements
		if ubound(AsgnArr)>0 then
			'Loop through assignment objects in loadcase
				for j = 0 to ubound(AsgnArr)
					'Get load attribute from assignment
					set LoadAtr = AsgnArr(j).getAttribute()
					if n=0 then
						'place first assignment load attribute in array
						set LoadArr(n) = AsgnArr(j).getAttribute()
						n=n+1
						
					elseif LoadAtr.getID = LoadArr(n-1).getID then
						' Load attribute already logged in load attribute array so do nothing for this assignment
						
					else
						'place next load attribute in load attribute in array
						ReDim Preserve LoadArr(n)
						set LoadArr(n) = AsgnArr(j).getAttribute()
						n=n+1
					end if
				next
		else
			'No load assignments in loadcase
			GetLoadsInLC = vbNull
			exit function
		end if

	txtwindow.writeline(VbCrLf & "Load attributes assigned in this Loadcase:")

	for i=0 to ubound(LoadArr)
	txtwindow.writeline(LoadArr(i).getname())
	next
	txtwindow.writeline(VbCrLf)
	GetLoadsInLC = LoadArr

End function

' ******************************************************************************


