$ENGINE=VBScript
'*********************************************************************
'* CreateMultipleSurfaces.vbs Rev 1                                  *
'* Created by Paul Marsden                                           *
'* Created at 10:32 on Monday, April 22 2013                         *
'* (C) FEA Ltd 2013                                                  *
'* Creates multiple triangular and quadrilateral surfaces from a     *
'* selection of lines                                                *
'*********************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS NOT      *
'* QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS IS BASIS    *
'* FOR DEMONSTRATION PURPOSES.                                       *
'*********************************************************************
'
' Get text window object
  set textWindow = getTextWindow()
  textWindow.writeLine("Creating multiple surfaces from the selected lines...")
  CountOfSurfaces = 0
  CountOfTriSurfaces = 0
  CountOfQuadSurfaces = 0
  StartTime = Timer
' Options to create triangular surfaces and/or quadrilateral surfaces.  A value of 1 is true/on and a value of 0 is false/off
  CrtTrnglSrfcOptn = 1
  CrtQudrltrlSrfcOptn = 1

' Create an empty group to store any lines where one line overlays two others
  call database.createEmptyGroup("LinesBridgingAnotherPairOfLines")

' use the selection provided by the user.  If only lines have been selected, lower order points are added to the selection
  AllOrigLines = selection.getObjects("Lines")
  call selection.addLOF("Point")
  call selection.keep("Points", "All")
  AllOrigPoints = selection.getObjects("Points")
' create an array of all point objects that define lines
  call database.options.setBoolean("associateDown", false)
  call selection.addHOF("Line")
  call selection.remove("Points", "All")
  call selection.keep(AllOrigLines)
  call selection.addLOF("Point")
  call selection.remove("Lines", "All")
  call database.options.setBoolean("associateDown", true)
  AllOrigPointsDefLines = selection.getObjects("Points")

' filter for an object set of points that define two or more lines of the original selection of lines
  set TempSetA = newObjectSet()
  For i = 0 to  UBound(AllOrigPointsDefLines)
    call database.options.setBoolean("associateDown", false)
    call selection.remove("All")
    set CurrPn = AllOrigPointsDefLines(i)
    CurrPnNum = CurrPn.getID()
    call selection.add("Point", CurrPnNum)
    call selection.addHOF("Line")
    call selection.keep(AllOrigLines)
    HOlines = selection.getObjects("Lines")
' check if the point has two higher order lines or more    
    If UBound(HOlines) >= 1 Then
      call TempSetA.add("Point", CurrPnNum)
    else
    end if
    call database.options.setBoolean("associateDown", true)
    set CurrPn = nothing
    set CurrPnNum= nothing
  Next
  AllOrigPointsDefTwoOrMoreLines = TempSetA.getObjects("Points")
  set TempSetA = nothing

  if ubound(AllOrigPointsDefTwoOrMoreLines) >= 0 then
' loop through all points defining two or more lines
    For j = 0 to ubound(AllOrigPointsDefTwoOrMoreLines)
      call selection.remove("All")
      set CurrPn = AllOrigPointsDefTwoOrMoreLines(j)
      CurrPnNum = CurrPn.getID()
      call database.options.setBoolean("associateDown", false)
      call selection.Add("Point", CurrPnNum)
      set TempSetA = newObjectSet()
      call TempSetA.add(selection)
      call TempSetA.addHOF("Line")
      call TempSetA.keep(AllOrigLines)
      call TempSetA.addLOF("Point")
      call TempSetA.addHOF("Line")
      call TempSetA.keep(AllOrigLines)
      call TempSetA.addLOF("Point")
      set SetOfLns = newObjectSet()
      set SetOfPts = newObjectSet()
      SetOfLns = TempSetA.getObjects("Lines")
      SetOfPts = TempSetA.getObjects("Points")
      set TempSetA = nothing

'loop through sets of 3 lines from the SetOfLns checking for 3 that have 3 lower order points, then create surface from the 3
      if ubound(SetOfLns) >= 2 and CrtTrnglSrfcOptn = 1 then 
        For l=0 to ubound(SetOfLns)-2
          For m=1 to ubound(SetOfLns)-1
            For n=2 to ubound(SetOfLns)
              If m<n then
                If l<m then
' create a temporary object set of three lines
                  set TempSetB = newObjectSet()
                  call TempSetB.add(SetOfLns(l))
                  call TempSetB.add(SetOfLns(m))
                  call TempSetB.add(SetOfLns(n))
' store each line as an individual line objects
                  set firstline = SetOfLns(l)
                  set secondline = SetOfLns(m)
                  set thirdline = SetOfLns(n)
' check that the three lines will not create a triangle of zero area
                  ZeroAreaTri=0
                  firstlinelength = firstline.getLineLength()
                  secondlinelength = secondline.getLineLength()
                  thirdlinelength = thirdline.getLineLength()
                  if firstlinelength = secondlinelength + thirdlinelength then ZeroAreaTri=1
                  if secondlinelength = firstlinelength + thirdlinelength then ZeroAreaTri=1
                  if thirdlinelength = firstlinelength + secondlinelength then ZeroAreaTri=1
                  if ZeroAreaTri=1 then call database.getGroupByName("LinesBridgingAnotherPairOfLines").add(TempSetB)
' create a temporary object set of the lower order points for the three lines
                  set TempSetBpoints  = newObjectSet()
                  call TempSetBpoints.add(TempSetB)
                  call TempSetBpoints.addLOF("Point")
                  call TempSetBpoints.keep("Points")
                  TempSetBpoints = TempSetBpoints.getObjects("Points")
' check that there are only three lower order points for the 3 lines to ensure that the lines are connected to form a triangle
                  If ubound(TempSetBpoints)=2 and ZeroAreaTri=0 then
' check whether a surface is already defined by these three lines and avoid creating a duplicate
                    set TempSetAllHOSurfaces  = newObjectSet()
                    set TempSetHOSurfacel = newObjectSet()
                    set TempSetHOSurfacem = newObjectSet()
                    set TempSetHOSurfacen = newObjectSet()
                    call TempSetHOSurfacel.add(firstline)
                    call TempSetHOSurfacel.addHOF("Surface")
                    call TempSetHOSurfacem.add(secondline)
                    call TempSetHOSurfacem.addHOF("Surface")
                    call TempSetHOSurfacen.add(thirdline)
                    call TempSetHOSurfacen.addHOF("Surface")
                    call TempSetAllHOSurfaces.add(TempSetB)
                    call TempSetAllHOSurfaces.addHOF("Surface")
                    call TempSetAllHOSurfaces.keep(TempSetHOSurfacel)
                    call TempSetAllHOSurfaces.keep(TempSetHOSurfacem)
                    call TempSetAllHOSurfaces.keep(TempSetHOSurfacen)
                    TempSetAllHOSurfaces = TempSetAllHOSurfaces.getObjects("Surfaces")
                    If ubound(TempSetAllHOSurfaces)=-1 then 
                      call CreateTriSurface(TempSetB)
                    else
                    end if
                  else
                    call selection.remove("All")
                    ' If the user has only selected three lines, then they are trying to create a single triangular surface but it has failed.  In this case the user may benefit from some information as to why
                    If ubound(AllOrigLines) = 2 then
                      call selection.add(TempSetB)
                      MsgBox("A surface could not be created.  The set of three lines L" & firstline.getID() & ", L" & secondline.getID() & " and L" & thirdline.getID() & " are defined by "& ubound(TempSetBpoints)+1 & " points")
                      call selection.remove("All")
                    else
                    end if
                  end if
                  set firstline = nothing
                  set secondline = nothing
                  set thirdline = nothing
                  set ZeroAreaTri = nothing
                  set firstlinelength = nothing

                  set secondlinelength = nothing

                  set thirdlinelength = nothing
                  set TempSetB = nothing
                  set TempSetBpoints = nothing
                  set TempSetAllHOSurfaces = nothing
                  set TempSetHOSurfacel = nothing
                  set TempSetHOSurfacem = nothing
                  set TempSetHOSurfacen = nothing
                else
                end if
              else
              end if
            Next
          Next
        Next
      elseif CrtTrnglSrfcOptn = 1 then 
        textWindow.writeLine("You must select at least three lines to create a surface")
      else
      end if

' create quadrilateral surfaces where triangles have already been created and check for existing triangles before creating quadrilaterals
' if the option to create triangles is turned off, no checks for existing triangles are made
      if CrtTrnglSrfcOptn = 1 and CrtQudrltrlSrfcOptn = 1 then
' Some checks on the number of points and lines selected:
' 5 lines and 4 points implies that there may be two triangles, or two lines sharing the same points therefore a quadrilateral surface should not be created
        if ubound(SetOfLns)=4 and ubound(SetOfPts)=3 then
' Less that 4 lines is not enough to create a quadrilateral surface.  If there are three lines then the script will have already tried to create a triangular surface
        elseif ubound(SetOfLns)<4 then
' loop through sets of 4 lines from the SetOfLns checking for 4 that have 4 lower order points, then create surface from the 4
        elseif ubound(SetOfLns) >= 3 and ubound(SetOfPts) >= 3 then 
          For l=0 to ubound(SetOfLns)-3
            For m=1 to ubound(SetOfLns)-2
              For n=2 to ubound(SetOfLns)-1
                For p=3 to ubound(SetOfLns)
                  If l<m then
                    If m<n then
                      If n<p then 
' create a temporary object set of four lines
                        set TempSetB = newObjectSet()
                        call TempSetB.add(SetOfLns(l))
                        call TempSetB.add(SetOfLns(m))
                        call TempSetB.add(SetOfLns(n))
                        call TempSetB.add(SetOfLns(p))
' store each line as an individual line object
                        set firstline = SetOfLns(l)
                        set secondline = SetOfLns(m)
                        set thirdline = SetOfLns(n)
                        set fourthline = SetOfLns(p)
' create a temporary object set of the lower order points for the four lines
                        set TempSetBpoints  = newObjectSet()
                        call TempSetBpoints.add(TempSetB)
                        call TempSetBpoints.addLOF("Point")
                        call TempSetBpoints.keep("Points")
                        TempSetBpoints = TempSetBpoints.getObjects("Points")
' check that there are only four lower order points for the 4 lines to ensure that the lines are connected to form a quadrilateral
                        If ubound(TempSetBpoints)=3 then
' check whether a quadrilateral surface is already defined by these four lines and avoid creating a duplicate quadrilateral surface
                          set TempSetAllHOSurfaces  = newObjectSet()
                          set TempSetHOSurfacel = newObjectSet()
                          set TempSetHOSurfacem = newObjectSet()
                          set TempSetHOSurfacen = newObjectSet()
                          set TempSetHOSurfacep = newObjectSet()
                          call TempSetHOSurfacel.add(firstline)
                          call TempSetHOSurfacel.addHOF("Surface")
                          call TempSetHOSurfacem.add(secondline)
                          call TempSetHOSurfacem.addHOF("Surface")
                          call TempSetHOSurfacen.add(thirdline)
                          call TempSetHOSurfacen.addHOF("Surface")
                          call TempSetHOSurfacep.add(fourthline)
                          call TempSetHOSurfacep.addHOF("Surface")
                          call TempSetAllHOSurfaces.add(TempSetB)
                          call TempSetAllHOSurfaces.addHOF("Surface")
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacel)
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacem)
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacen)
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacep)
' check whether a triangular surface is already defined by any three of these four lines and avoid creating a duplicate triangular surface
                          set TempSetAllHOSurfaces1 = newObjectSet()
                          set TempSetAllHOSurfaces2 = newObjectSet()
                          set TempSetAllHOSurfaces3 = newObjectSet()
                          set TempSetAllHOSurfaces4 = newObjectSet()
                          call TempSetAllHOSurfaces1.add(TempSetB)
                          call TempSetAllHOSurfaces1.addHOF("Surface")
                          call TempSetAllHOSurfaces1.keep(TempSetHOSurfacel)
                          call TempSetAllHOSurfaces1.keep(TempSetHOSurfacem)
                          call TempSetAllHOSurfaces1.keep(TempSetHOSurfacen)
                          call TempSetAllHOSurfaces2.add(TempSetB)
                          call TempSetAllHOSurfaces2.addHOF("Surface")
                          call TempSetAllHOSurfaces2.keep(TempSetHOSurfacel)
                          call TempSetAllHOSurfaces2.keep(TempSetHOSurfacem)
                          call TempSetAllHOSurfaces2.keep(TempSetHOSurfacep)
                          call TempSetAllHOSurfaces3.add(TempSetB)
                          call TempSetAllHOSurfaces3.addHOF("Surface")
                          call TempSetAllHOSurfaces3.keep(TempSetHOSurfacel)
                          call TempSetAllHOSurfaces3.keep(TempSetHOSurfacen)
                          call TempSetAllHOSurfaces3.keep(TempSetHOSurfacep)
                          call TempSetAllHOSurfaces4.add(TempSetB)
                          call TempSetAllHOSurfaces4.addHOF("Surface")
                          call TempSetAllHOSurfaces4.keep(TempSetHOSurfacem)
                          call TempSetAllHOSurfaces4.keep(TempSetHOSurfacen)
                          call TempSetAllHOSurfaces4.keep(TempSetHOSurfacep)
                          TempSetAllHOSurfaces1 = TempSetAllHOSurfaces1.getObjects("Surfaces")
                          TempSetAllHOSurfaces2 = TempSetAllHOSurfaces2.getObjects("Surfaces")
                          TempSetAllHOSurfaces3 = TempSetAllHOSurfaces3.getObjects("Surfaces")
                          TempSetAllHOSurfaces4 = TempSetAllHOSurfaces4.getObjects("Surfaces")
                          call TempSetAllHOSurfaces.add(TempSetAllHOSurfaces1)
                          call TempSetAllHOSurfaces.add(TempSetAllHOSurfaces2)
                          call TempSetAllHOSurfaces.add(TempSetAllHOSurfaces3)
                          call TempSetAllHOSurfaces.add(TempSetAllHOSurfaces4)
                          TempSetAllHOSurfaces = TempSetAllHOSurfaces.getObjects("Surfaces")
' clear variables
                          set TempSetHOSurfacel = nothing
                          set TempSetHOSurfacem = nothing
                          set TempSetHOSurfacen = nothing
                          set TempSetHOSurfacep = nothing
                          set TempSetAllHOSurfaces1 = nothing
                          set TempSetAllHOSurfaces2 = nothing
                          set TempSetAllHOSurfaces3 = nothing
                          set TempSetAllHOSurfaces4 = nothing
                          If ubound(TempSetAllHOSurfaces)=-1 then 
' check for triangular surfaces where there are 5 lines sharing 4 points
                            TriangularSurface = 0  
                            set TempSetE = newObjectSet()
                            call TempSetE.add(SetOfLns(l))
                            call TempSetE.add(SetOfLns(m))
                            call TempSetE.add(SetOfLns(n))
                            call TempSetE.add(SetOfLns(p))
                            For q=0 to ubound(SetOfLns)
                              If q=l or q=m or q=n or q=p then
                              else
                                set fifthline = SetOfLns(q)
                                set TempSetF = newObjectSet()
                                call TempSetF.add(TempSetE)
                                call TempSetF.add(SetOfLns(q))
' create a temporary object set of the lower order points for the five lines
                                set TempSetFpoints  = newObjectSet()
                                call TempSetFpoints.add(TempSetF)
                                call TempSetFpoints.addLOF("Point")
                                call TempSetFpoints.keep("Points")
                                TempSetFpoints = TempSetFpoints.getObjects("Points")
                                If ubound(TempSetFpoints)=3 then
                                  TriangularSurface = 1  
                                else
                                end if
                                set fifthline = nothing
                                set TempSetF = nothing
                                set TempSetFpoints = nothing
                              End if
                            Next
'create a quadrilateral surface if there are no triangular surfaces contained inside the four lines
                            if TriangularSurface = 0 then 
                              call CreateQuadSurface(TempSetE)
                            else
                            end if
' clear variables
                            set TriangularSurface = nothing
                          else
                          end if
                            set TempSetE = nothing
                        else
                          call selection.remove("All")
                          ' If the user has only selected four lines, then they are trying to create a single quadrilateral surface but it has failed.  In this case the user may benefit from some information as to why
                          If ubound(AllOrigLines) = 3 then
                            call selection.add(TempSetB)
                            MsgBox("A surface could not be created.  The set of four lines L" & firstline.getID() & ", L" & secondline.getID() & ", L" & thirdline.getID() & " and L" & fourthline.getID() & " are defined by "& ubound(TempSetBpoints)+1 & " points")
                            call selection.remove("All")
                          else
                          end if
                        end if
                        set firstline = nothing
                        set secondline = nothing
                        set thirdline = nothing
                        set fourthline = nothing
                        set TempSetB = nothing
                        set TempSetBpoints = nothing
                      else
                      end if
                    else
                    end if
                  else
                  end if

                Next
              Next
            Next
          Next
        else
        end if
      elseif CrtTrnglSrfcOptn = 0 and CrtQudrltrlSrfcOptn = 1 then
' loop through sets of 4 lines from the SetOfLns checking for 4 that have 4 lower order points, then create surface from the 4
        if ubound(SetOfLns) >= 3 and ubound(SetOfPts) >= 3 then 
          For l=0 to ubound(SetOfLns)-3
            For m=1 to ubound(SetOfLns)-2
              For n=2 to ubound(SetOfLns)-1
                For p=3 to ubound(SetOfLns)
                  If l<m then
                    If m<n then
                      If n<p then 
' create a temporary object set of four lines
                        set TempSetB = newObjectSet()
                        call TempSetB.add(SetOfLns(l))
                        call TempSetB.add(SetOfLns(m))
                        call TempSetB.add(SetOfLns(n))
                        call TempSetB.add(SetOfLns(p))
' store each line as an individual line object
                        set firstline = SetOfLns(l)
                        set secondline = SetOfLns(m)
                        set thirdline = SetOfLns(n)
                        set fourthline = SetOfLns(p)
' create a temporary object set of the lower order points for the four lines
                        set TempSetBpoints  = newObjectSet()
                        call TempSetBpoints.add(TempSetB)
                        call TempSetBpoints.addLOF("Point")
                        call TempSetBpoints.keep("Points")
                        TempSetBpoints = TempSetBpoints.getObjects("Points")
' check that there are only four lower order points for the 4 lines to ensure that the lines are connected to form a quadrilateral
                        If ubound(TempSetBpoints)=3 then
' check whether a quadrilateral surface is already defined by these four lines and avoid creating a duplicate quadrilateral surface
                          set TempSetAllHOSurfaces  = newObjectSet()
                          set TempSetHOSurfacel = newObjectSet()
                          set TempSetHOSurfacem = newObjectSet()
                          set TempSetHOSurfacen = newObjectSet()
                          set TempSetHOSurfacep = newObjectSet()
                          call TempSetHOSurfacel.add(firstline)
                          call TempSetHOSurfacel.addHOF("Surface")
                          call TempSetHOSurfacem.add(secondline)
                          call TempSetHOSurfacem.addHOF("Surface")
                          call TempSetHOSurfacen.add(thirdline)
                          call TempSetHOSurfacen.addHOF("Surface")
                          call TempSetHOSurfacep.add(fourthline)
                          call TempSetHOSurfacep.addHOF("Surface")
                          call TempSetAllHOSurfaces.add(TempSetB)
                          call TempSetAllHOSurfaces.addHOF("Surface")
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacel)
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacem)
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacen)
                          call TempSetAllHOSurfaces.keep(TempSetHOSurfacep)
                          TempSetAllHOSurfaces = TempSetAllHOSurfaces.getObjects("Surfaces")
' clear variables
                          set TempSetHOSurfacel = nothing
                          set TempSetHOSurfacem = nothing
                          set TempSetHOSurfacen = nothing
                          set TempSetHOSurfacep = nothing
                          If ubound(TempSetAllHOSurfaces)=-1 then 
                            set TempSetE = newObjectSet()
                            call TempSetE.add(SetOfLns(l))
                            call TempSetE.add(SetOfLns(m))
                            call TempSetE.add(SetOfLns(n))
                            call TempSetE.add(SetOfLns(p))
                            call CreateQuadSurface(TempSetE)
                          else
                          end if
                          set TempSetE = nothing
                          set TempSetAllHOSurfaces = nothing
                        else
                          call selection.remove("All")
                          ' If the user has only selected four lines, then they are trying to create a single quadrilateral surface but it has failed.  In this case the user may benefit from some information as to why
                          If ubound(AllOrigLines) = 3 then
                            call selection.add(TempSetB)
                            MsgBox("A surface could not be created.  The set of four lines L" & firstline.getID() & ", L" & secondline.getID() & ", L" & thirdline.getID() & " and L" & fourthline.getID() & " are defined by "& ubound(TempSetBpoints)+1 & " points")
                            call selection.remove("All")
                          else
                          end if
                        end if
                        set firstline = nothing
                        set secondline = nothing
                        set thirdline = nothing
                        set fourthline = nothing
                        set TempSetB = nothing
                        set TempSetBpoints = nothing
                      else
                      end if
                    else
                    end if
                  else
                  end if

                Next
              Next
            Next
          Next
        else
        end if
      else
      end if
    Next
' clear variables
    set SetOfLns = nothing
    set SetOfPts = nothing
    call database.options.setBoolean("associateDown", true)
    set CurrPn = nothing
    set CurrPnNum= nothing
  else
   textWindow.writeLine("No surfaces created - there were no pairs of lines in the original selection that shared a common point")
  end if
' clear selection and variables
  call selection.remove("All")
  set AllOrigLines = nothing
  set AllOrigPoints = nothing
  set AllOrigPointsDefLines = nothing
  set AllOrigPointsDefTwoOrMoreLines = nothing
  textWindow.writeLine("...Finished. " & CountOfSurfaces & " new surfaces created. " & CountOfTriSurfaces & " triangular surfaces and " & CountOfQuadSurfaces & " quadrilateral surfaces created in " & Timer-StartTime & " seconds")
  set CountOfSurfaces = nothing
  set CountOfTriSurfaces = nothing
  set CountOfQuadSurfaces = nothing

' create traingular surface from 3 lines
sub CreateTriSurface(TempSetC)
    call CreateSurface(TempSetC)
' Write line to text window
  textWindow.writeLine("Triangular surface created using lines:  L" & firstline.getID() & ", L" & secondline.getID() & " and L" & thirdline.getID())
' clear variables
  set TempSetC = nothing
  CountOfTriSurfaces = CountOfTriSurfaces+1
end sub

' create quadrilateral surface from 4 lines
sub CreateQuadSurface(TempSetD)
' create the surface
    call CreateSurface(TempSetD)
' Write line to text window
  textWindow.writeLine("Quadrilateral surface created using lines:  L" & firstline.getID() & ", L" & secondline.getID() & ", L" & thirdline.getID() & " and L" & fourthline.getID())
' clear variables
  set TempSetD = nothing
  CountOfQuadSurfaces = CountOfQuadSurfaces+1
end sub

' create surface
sub CreateSurface(TempSetLines)
  call geometryData.setAllDefaults()
  call geometryData.setCreateMethod("unset")
  call geometryData.setLowerOrderGeometryType("lines")
  TempSetLines.createSurface(geometryData)
' clear variables
  set TempSetLines = nothing
  CountOfSurfaces = CountOfSurfaces+1
end sub