'Script to assign a moving point load of varying intensity
'LUSAS Support, October 2012 - Current LUSAS version 14.7-9
' *** Provided for demonstration purposes only *** 
'-------------------------------------------------------------------------------------
'INSTRUCTIONS
'Draw a line across the structure to represent the path of the moving load.
'Run the script and enter the required data in the input boxes.
'All existing loading and loadcases (except load case 1) will be deleted.
'-------------------------------------------------------------------------------------

'Initialise
$ENGINE=VBSCRIPT

'Activate text window
Set textwindow=gettextwindow()

'get lines in selection
numLines = selection.count("Lines")

	'check number of lines
	If numlines = 1 Then
	
	'Get search areas and issue warning if none assigned
	searchAreas = db.getAttributes("Search Area", "All")
		If UBound(searchAreas) = 0 Then
		searchAreaExists = True
		Set searchArea = searchAreas(0)
		ElseIf UBound(searchAreas) > 0 Then
		searchAreaExists = True
		searchAreaID = InputBox("Please enter name of search area for application of load","Search Area",searchAreas(0).getName())
		Set searchArea = db.getAttribute("Search Area", searchAreaID)
		Else
		SearchAreaQuery = MsgBox("No search area assigned. Would you like to continue?",1, "No Search Area")
			If SearchAreaQuery = 2 Then stopScript()
		End If
	
	'Create copy of model
	filename = db.getDBFilenameNoExtension()	
	copyName = filename & "_Dynamic.mdl"
	db.saveas(copyName)
	
	'Get input data	
	title = "Moving Load Analysis"
	nRows = 3
	' nColumns = 0
	ReDim rowHeader(nRows)
	ReDim colHeaders(nColumns)
	ReDim data(nColumns ,nRows)
	rowHeader(0)  = "Amplitude of the load"
	rowHeader(1)  = "Speed at which the load is travelling"
	rowHeader(2)  = "Frequency of the load (Hz)"
	rowHeader(3)  = "Time step for the dynamic analysis"
	'initial (default) data
	data(0, 0)  = "100"
	data(0, 1)  = "1"
	data(0, 2)  = "1"
	data(0, 3)  = "0.05"
	okPressed = createSimpleDialog(title, rowHeader, colHeaders, data, true, true, false)
		If (okPressed) then
		loadIntensity=data(0,0)
		loadSpeed=data(0,1)
		loadFrequency=data(0,2)
		timeStep=data(0,3)
			
		'set constant Pi
		Pi = 3.14159265359
	
			'close any results
			If db.countresultsfiles() > 0 Then
			Call db.closeAllResults()
			End if	
		
		'Deassign any existing loading
		existingLoading = database.getAttributes("Loading","All")
			For i = 0 To UBound(existingLoading)
			database.deleteAttribute(existingLoading(i))
			Next
				
		'delete loadcases other than the first
		loadsets = db.getloadsets("all")
			If db.countLoadsets(loadsets) > 1 then
				For i = 1 To UBound(loadsets)
				Call db.deleteLoadset(loadsets(i))
				Next
			End If
		
		'Get line representing load path
		Set loadPath = selection.getObject("Line")
			
		'get end points
		endPoints = loadPath.getLOFs()
				
		'get line length
		pathLength = loadPath.getLineLength()
		
		'get array of all points currently in the model
		pointsArray = db.getObjects("Points","All")
		
		'calculate number of time steps required
		timeSteps = (pathLength / (loadSpeed * timeStep))
		splitNum = Int (timesteps)
		
		'split line
		call geometryData.setAllDefaults()
			For i = 1 To splitNum
			If i/timesteps < 1 then
			call geometryData.addSplitParametric(0, i/timeSteps)
			End if
			Next
		set tempSetA = newObjectSet()
		call tempSetA.add(selection, "Line")
		set returnedSetA = tempSetA.splitLine(geometryData)
		set tempSetA = nothing
		call database.updateMesh()
	
		'get array of new points
		Set tempPointSet = newObjectSet()
		Call tempPointSet.add("Points","All")
		Call tempPointSet.remove(pointsArray)
		call tempPointSet.add(endPoints)
		loadPoints = tempPointSet.getObjects("Points")
			
		'create point load
		redim FEAtemp(2)
		FEAtemp(0) = 0.0
		FEAtemp(1) = 0.0
		FEAtemp(2) = 1.0
		set attr = database.createLoadingDiscretePoint("Point Load")
		call attr.setDiscrete("Z", FEAtemp, 0, 0)
		call attr.addRow(0.0, 0.0, 0.0, -loadIntensity)
		erase FEAtemp
		set attr = Nothing
		
		'set starting step number for loadcase titles
		stepNumber = 1
		loadsets = db.getloadsets("all")
		call  loadsets(UBound(loadsets)).setName("Time step 1, t = 0")
		
		'assign loading to first time step (with factor 0 because t = 0)
		Call selection.remove("All")
		Call selection.add(endpoints(0))
		call assignment.setAllDefaults()
		call assignment.setLoadFactor(0)
		call assignment.setLoadMoving("Exclude All Load")
		call assignment.setSearchAssignType("area")
		call database.getAttribute("Discrete Point Load", "Point Load").assignTo(selection, assignment)
		Call selection.getObject("Point").setPen(2)
		
		'set counter for recording loading data
		numRows = 1
		
		'remove current point from tempPointSet
		Call tempPointSet.remove(selection)
		
		textwin.writeline("Applying loading")	
						
			'loop time steps
			For ResponseTime = timeStep To timeSteps*timeStep Step timeStep
			responseTime = Round(ResponseTime,5)
			
			'create new loadset and set active
			call database.createLoadcase("Time step " & stepNumber & ", t = " & responseTime)
			stepNumber = stepNumber + 1	
			loadsets = db.getloadsets("all")
			call view.setActiveLoadset(loadsets(UBound(loadsets)))
			' =====================================================
			' Calculate loading factor using sine wave loading function
			' Change this relation if any other variation is required.  
			loadFactor = Sin (loadFrequency * 2 * Pi * ResponseTime)
				If Abs(loadFactor) < 1e-6 Then loadFactor = 1e-6
			' =====================================================
			'select next point
			currentPoints = selection.getObjects("Points")
			Call selection.add(tempPointSet)
			Set nextPoint = currentPoints(0).getNearestObjectIn(selection)
			Call selection.remove("all")
			Call selection.add(nextPoint)
					
			'assign load
			call assignment.setAllDefaults()
			call assignment.setLoadFactor(loadFactor)
			call assignment.setLoadMoving("Exclude All Load")
			call assignment.setSearchAssignType("area")			
				If searchAreaExists Then
				call assignment.setSearchArea(searchArea)
				End if
			call database.getAttribute("Discrete Point Load", "Point Load").assignTo(selection, assignment)
			Call selection.getObject("Point").setPen(2)
			
				'write loading to array for pasting to spreadsheet
				If NumRows = 1 Then
				Dim loadHistory
				ReDim loadHistory(2,1)
				loadHistory(0,0) = 0
				loadHistory(1,0) = 0
				loadHistory(2,0) = 0
				Else
				ReDim Preserve loadHistory(2,NumRows)
				End if
			loadHistory(0,numRows) = Round(responseTime/timeStep,5)
			loadHistory(1,numRows) = Round(responseTime,5)
			loadHistory(2,numRows) = Round(loadFactor,5)
			numRows = numRows + 1
					
			'remove current point from selection
			Call tempPointSet.remove(selection)
					
			Next
			
		'set Transient controls
		call database.options.setBoolean("Option 275", false)
		set loadcase = database.getLoadset("Time step 1, t = 0", 0)
		call loadcase.setTransientControl(0)
		call loadcase.getTransientControl().setValue("CouplingReadInterval", 1.0).setValue("CouplingWriteInterval", 1.0)
		call loadcase.getTransientControl().setTimeDomainDynamics(timeStep, false).setValue("TimeStepScaleFactor", 0.9).setValue("PermissableTimeSteps", 0)
		call loadcase.getTransientControl().setValue("TimeStepRestrictionFactor", 1.0).setValue("MinTimeStepFactor", 0.0).setValue("MaxTimeStepFactor", 100.0E6)
		call loadcase.getTransientControl().setValue("TotalResponseTime", 100.0E6).setValue("MinTimeStep", 0.0)
		call loadcase.getTransientControl().setConstants().setValue("nit", 30).setValue("nalps", 2).setValue("toline", 0.75).setValue("rmaxal", 100.0E6)
		call loadcase.getTransientControl().setValue("rnoral", 100.0E6).setValue("dlnorm", 1.0).setValue("rlnorm", 0.1).setValue("wlnorm", 100.0E6)
		call loadcase.getTransientControl().setValue("dtnrml", 1.0).setValue("ampmx", 5.0).setValue("etmxa", 25.0).setValue("etmna", 0.0)
		call loadcase.getTransientControl().setValue("alpha", 0.0).setValue("beta", 0.25).setValue("gamma", 0.5).setValue("isilcp", false)
		call loadcase.getTransientControl().setOutput().setValue("IncrementIntervalForLusas", 1).setValue("IncrementIntervalForPlotFile", 1).setValue("IncrementIntervalForRestart", 0)
		call loadcase.getTransientControl().setValue("MaxRestartDumpsSaved", 0).setValue("IncrementIntervalForTimeStepLog", 1).setValue("IncrementIntervalForHistory", 1)
		set loadcase = Nothing
		
		textwin.writeline("Loading complete. Creating summary spreadsheet.")
	
		'create summary spreadsheet
		' =======================================
		' open Excel application
			set ExcelApp = CreateAutomationObject("Excel.Application")
		' set Names of workbook and worksheet
			call initialiseExcelApp(ExcelApp, "Dynamic Factors", "LusasOutput")
		' get Excel Object
			set WorkBook = ExcelApp.WorkBooks(1)
			set WorkSheet= WorkBook.WorkSheets(1)
			
'		Set objExcel = CreateObject("Excel.Application")
			
			'write general data and row headings
			title = db.getDBfilename()
			WorkSheet.Cells(1,1).value = ("Summary of Dynamic Moving Load Application to Model " & title)
			WorkSheet.Cells(4,1).value = ("Moving load intensity is " & loadIntensity)
			WorkSheet.Cells(5,1).value = ("Load speed is " & loadSpeed)
			WorkSheet.Cells(6,1).value = ("Load frequency is " & loadFrequency)
			WorkSheet.Cells(7,1).value = ("Time step interval is " & timeStep)
			WorkSheet.Cells(9,1).value = ("Load step number")
			WorkSheet.Cells(9,2).value = ("Response Time")
			WorkSheet.Cells(9,3).value = ("Load Factor")
			
			'fill in loading data
			numRows = numRows-1
			row = 10
				For i = 0 To Numrows
					WorkSheet.Cells(row,1).value = (loadHistory(0,i))
					WorkSheet.Cells(row,2).value = (loadHistory(1,i))
					WorkSheet.Cells(row,3).value = (loadHistory(2,i))
					row = row + 1
				Next
			
			'format cells	
			WorkSheet.Range("A1").Font.Size = 18
			WorkSheet.Columns("A:C").Select
			WorkSheet.Range("A9:C9").Font.Bold = True
			
			
		textwin.writeline("Spreadsheet complete.")
	
		end If 'If OK pressed					

	'Display messages if number of selected lines is not 1
	ElseIf numLines = 0 then	
	MsgBox("No lines selected. Please select one line representing the moving load path before running the script.")
 	ElseIf numLines > 1 then
	MsgBox("Too many lines selected. Please select one line representing the moving load path before running the script.")
 	End If
	
	' ==================== 
' save Excel work book in default file directory
    Fname=getCWD() & "\" & WorkBook.Title + ".xlsx"
    WorkBook.SaveAs(Fname)
     getTextwindow().writeLine("Excel Document " & Fname & " created")
' quit Excel
    ExcelApp.Quit
	set ExcelApp = Nothing 
' =============================== 
Sub initialiseExcelApp(ExcelObj, workBookName, sheetName)
    Const TemporaryFolder = 2
' set file directory as Windows temporary directory
    FilePath = CreateObject("Scripting.FileSystemObject").GetSpecialFolder(TemporaryFolder)
    ExcelObj.DefaultFilePath = FilePath
' get workbook
    set WB = ExcelObj.WorkBooks.Add
    WB.Title = workBookName
' get worksheet
    set WS = WB.Worksheets(1)
    WS.Name = sheetName
End Sub

