$ENGINE=VBScript
'**************************************************************
'* LoadFactor.vbs                                             *
'* Created 7th January 2010                                   *
'* Creates a comma separated value file ofthe assigned load   *
'* factors of all assigned loads for all loadcases to be      *
'* opened in a spreadsheet application                        *
'**************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS   *
'* NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS  *
'* IS BASIS FOR DEMONSTRATION PURPOSES.                       *
'**************************************************************
'
Dim fileSys
Set fileSys = CreateObject("Scripting.FileSystemObject")
csvFileName = db.getDBFilenameNoExtension() & "_Load_Factors.csv"
Set csvFile = fileSys.CreateTextFile (csvFilename, True)
temStr = "load case ID" & "," & "load case name" & "," & "attribute ID" & "," & "attribute name" & "," & "assign type" & "," & "assign ID" & "," & "assign name" & "," & "load factor"
Call csvFile.writeLine(temStr)

arrayLoadsets = database.getLoadsets("all")
For i = 0 to ubound(arrayLoadsets)
    If arrayLoadsets(i).getTypeCode() = 0 Then
        arrayAssign = arrayLoadsets(i).getAssignments("load")
        For j = 0 to ubound(arrayAssign)
            loadcaseID = arrayLoadsets(i).getID
            loadcaseName = arrayLoadsets(i).getName
            attrID = arrayAssign(j).getAttribute().getID
            attrName = arrayAssign(j).getAttribute().getName

            Set obj = arrayAssign(j).getDatabaseObject()
            typeCode = obj.getTypeCode

            If typeCode = 1 Then 
                assignType = "point"
            ElseIf typeCode = 2 Then 
                assignType = "line"
            ElseIf typeCode = 3 Then 
                assignType = "combined line"
            ElseIf typeCode = 4 Then 
                assignType = "surface"
            ElseIf typeCode = 5 Then 
                assignType = "volume"
            End If

            assignID = obj.getID
            assignName = obj.getName
            loadFactor = arrayAssign(j).getLoadfactor

            loadcaseName = Replace(loadcaseName, ",", "")
            attrName = Replace(attrName, ",", "") 
            assignName = Replace(assignName, ",", "") 

            temStr = loadcaseID & "," & loadcaseName & "," & attrID & "," & attrName & "," & assignType & "," & assignID & "," & assignName & "," & loadFactor
            Call csvFile.writeLine(temStr)
        Next
    End If
Next
csvFile.Close()

  set textWindow = getTextWindow()
  textwindow.writeline("Table of assigned loads and load factors saved to " & csvFilename)
  set textWindow = Nothing

