$ENGINE=VBScript
'*************************************************************
'* NumberFeatureByName.vbs Rev 2                             *
'* Created at 15:18 on Tuesday, July 12 2011                 *
'* Revised at 16:37 on Tuesday, July 12 2011                 *
'* This script gives selected features a name that includes  *
'* a prefix and sequential numbering in the order that the   *
'* features were selected starting at a specified number     *
'*************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS  *
'* NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS *
'* IS BASIS FOR DEMONSTRATION PURPOSES.                      *
'*************************************************************
'* Instructions:                                             *
'* =============                                             *
'* Select a series of points, lines, surfaces or volumes and *
'* run this script in Modeller via File>Script>Run Script    *
'* Hold Shift on the keyboard whilst single left clicking on *
'* the geometry items you are selecting to add them into     *
'* selection one by one in order.                            *
'* If the selection is of points, then these points will be  *
'* named in the order selected as P1, P2, P3 and so on.      *
'* If the selection is of lines, then these lines will be    *
'* named in the order selected as L1, L2, L3 and so on.      *
'* Similarly for surfaces or volumes if selected             *
'* The prefix can be edited in the script, but not blank and *
'* a suffix may also be defined but is blank by default      *
'*************************************************************
'
call setCreationVersion("14.5-4")
'
'*** Determine numbers of each geometry object selected
NumOfPoints = selection.count("Point")
NumOfLines = selection.count("Line")
NumOfSurfaces = selection.count("Surface")
NumOfVolumes = selection.count("Volume")
'
'*** Check selection
CountOfPLSandV = NumOfPoints + NumOfLines + NumOfSurfaces + NumOfVolumes
If CountOfPLSandV = 0 Then
   MsgBox("Selection does not contain any points, lines, surfaces or volumes" & Chr(13) & Chr(13) & "Hold Shift on the keyboard whilst single left clicking on the geometry items you are selecting to add them into selection one by one in the order required.  Then run the script again.")
Else
call NameGeometryObjects()
End If
'
'
'
Sub NameGeometryObjects()
'
'*** Set the number to start at
NumStart = InputBox("Enter a number to start the numbering at:", "Number Feature By Name") 

'
'*** Define prefixes
PrePoints = "P"
PreLines = "L"
PreSurfaces = "S"
PreVolumes = "V"
'
'*** Define suffixes - None specified by default - edit if required
SuffPoints = ""
SuffLines = ""
SuffSurfaces = ""
SuffVolumes = ""
'
'*** Name Point features selected in selection order
If NumOfPoints <> 0 Then
   '*** Create object arrays for Points selected
   points = selection.getObjects("Points", "All")
   If SuffPoints <> "" Then
      For i = 0 to ubound(points)
         '*** Set Point name with suffix
         NumPoint = i + NumStart
         call points(i).setName(PrePoints & NumPoint & SuffPoints)      
      Next
   Else
      For i = 0 to ubound(points)
         '*** Set Point name without suffix
         NumPoint = i + NumStart
         call points(i).setName(PrePoints & NumPoint)      
      Next
   End If
   '*** Report number of geometry objects given names in the text output window
   set tw = getTextWindow()
   tw.writeline(NumOfPoints & " Point(s) have been named")
   set points = nothing
Else
End If
'
'*** Name Line features selected in selection order
If NumOfLines <> 0 Then
   '*** Create object arrays for Lines selected
   lines = selection.getObjects("Lines", "All")
   If SuffLines <> "" Then
      For i = 0 to ubound(lines)
         '*** Set Line name with suffix
         NumLine = i + NumStart
         call lines(i).setName(PreLines & NumLine & SuffLines)      
      Next
   Else
      For i = 0 to ubound(lines)
         '*** Set Line name without suffix
         NumLine = i + NumStart
         call lines(i).setName(PreLines & NumLine)      
      Next
   End If
   '*** Report number of geometry objects given names in the text output window
   set tw = getTextWindow()
   tw.writeline(NumOfLines & " Line(s) have been named")
   set lines = nothing
Else
End If
'
'*** Name Surface features selected in selection order
If NumOfSurfaces <> 0 Then
   '*** Create object arrays for Surfaces selected
   surfaces = selection.getObjects("Surfaces", "All")
   If SuffSurfaces <> "" Then
      For i = 0 to ubound(surfaces)
         '*** Set Surface name with suffix
         NumSurface = i + NumStart
         call surfaces(i).setName(PreSurfaces & NumSurface & SuffSurfaces)      
      Next
   Else
      For i = 0 to ubound(surfaces)
         '*** Set Surface name without suffix
         NumSurface = i + NumStart
         call surfaces(i).setName(PreSurfaces & NumSurface)      
      Next
   End If
   '*** Report number of geometry objects given names in the text output window
   set tw = getTextWindow()
   tw.writeline(NumOfSurfaces & " Surface(s) have been named")
   set surfaces = nothing
Else
End If
'
'*** Name Volume features selected in selection order
If NumOfVolumes <> 0 Then
   '*** Create object arrays for Volumes selected
   volumes = selection.getObjects("Volumes", "All")
   If SuffVolumes <> "" Then
      For i = 0 to ubound(volumes)
         '*** Set Volume name with suffix
         NumVolume = i + NumStart
         call volumes(i).setName(PreVolumes & NumVolume & SuffVolumes)      
      Next
   Else
      For i = 0 to ubound(volumes)
         '*** Set Volume name without suffix
         NumVolume = i + NumStart
         call volumes(i).setName(PreVolumes & NumVolume)      
      Next
   End If
   '*** Report number of geometry objects given names in the text output window
   set tw = getTextWindow()
   tw.writeline(NumOfVolumes & " Volume(s) have been named")
   set volumes = nothing
Else
End If
'
call selection.remove("All")
End Sub