$ENGINE=VBScript

'NB Assumes Z vertical

set textWindow = getTextWindow()
Pi = 3.1415926

'Get selected lines
lines = selection.getObjects("lines", "all")
call selection.remove("all")

'Create beam mesh attribute
set attr = database.createMeshLine("BTS3 1Div")
call attr.setSpacing("BTS3")
call attr.addSpacing(1, 1.0)
call attr.setValue("uiSpacing", "uniform")
set attr = nothing

'Delete existing unused local coordinates
call database.getAttribute("Line Mesh", "BTS3 1Div").deassignFrom(lines, assignment)
Call database.deleteAttributes("Local Coordinates", "All")

'loop lines
For i=0 To UBound(lines)

	'get end points
	startpos=lines(i).getStartPosition
	X1=startpos(0)
	Y1=startpos(1)
	Z1=startpos(2)
	
	endpos=lines(i).getendposition
	X2=endpos(0)
	Y2=endpos(1)
	Z2=endpos(2)

	'Calulate coordinate differences
	Xdiff=X2-X1
	Ydiff=Y2-Y1
	Zdiff=Z2-Z1

	'use adjustment to prevent divide by zero error
	If Xdiff=0 Then
	xdiff=1E-10
	End if
	
	'calculate angle from X-axis
	radians=Atn(Ydiff/Xdiff)
	If Xdiff>0 Then
	degrees=180/Pi*radians
	Else 
	degrees=180/Pi*radians+180
	End if

	'Create local coordinate attribute
	linenumber=lines(i).GetID
	coord="Local Coordinate for Line "&linenumber

		'create Local Coords for special case of vertical line (up)
		If xdiff=1E-10 And ydiff=0 And zdiff>0 Then
		redim setOrigin(2)
		setOrigin(0) = 0.0
		setOrigin(1) = 0.0
		setOrigin(2) = 0.0
		set attr = database.createLocalCartesianXZAttr(coord, -90.0, setOrigin).setAxesType("Cartesian")
		attr.visualiseDefn(false)
		set attr = nothing

		'create Local Coordinates for special case of vertical line (down)
		Else if xdiff=1E-10 And ydiff=0 And zdiff<0 Then
		redim setOrigin(2)
		setOrigin(0) = 0.0
		setOrigin(1) = 0.0
		setOrigin(2) = 0.0
		set attr = database.createLocalCartesianXZAttr(coord, 90.0, setOrigin).setAxesType("Cartesian")
		attr.visualiseDefn(false)
		set attr = nothing

		'create Local Coordinates for any other line
		Else
		redim setOrigin(2)
		setOrigin(0) = 0.0
		setOrigin(1) = 0.0
		setOrigin(2) = 0.0
		set attr = database.createLocalCartesianXYAttr(coord, degrees, setOrigin).setAxesType("Cartesian")
		attr.visualiseDefn(false)
		set attr = Nothing

		End If
		End If
		
	'Assign beam mesh by local coordinate
	call selection.add(lines(i))
	Set localCoord = database.getAttribute("Local Coordinates", coord)
	Call assignment.setAllDefaults()
	Call assignment.setLocalCoord(localCoord)
	Set localCoord = nothing
	Call database.getAttribute("Line Mesh", "BTS3 1Div").assignTo(selection, assignment)
	call selection.remove("All")

Next

'Remesh
call database.updateMesh()
textWindow.writeLine("Mesh assigned to "&i&" lines")