$ENGINE=VBScript
'********************************************************************************
'* PrintBeamFibreStresses.vbs                                 					*
'* Created 23rd Aug  2010                                     					*
'* Outputs unaveraged nodal beam stress results to an excel spreadsheet for all *
'* fibre locations of all 3D thick beam elements in the model.					*
'* Results are initially ordered by geoemtric attribute, then fibre location, 	*
'* then element, then node. However the 'autofilter' tool in Excel can be used	*
'* to easily filter and sort results into the desired format.					*
'* This script is currently only valid for use with 3D thick beams				*
'* Note that the 'Opt_IncCoor' option below can be used to turn on and off 		*
'* writing of nodal coordinates.												*
'********************************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS   					*
'* NOT QUALITY APPROVED OR SUPPORTED. IT IS PROVIDED ON AN AS  					*
'* IS BASIS FOR DEMONSTRATION PURPOSES.                       					*
'********************************************************************************

' ---------------------------------------------------------------------------------------------------------
' Debugging using an ineractive VBS editor (say VBEdit or similar)
' In V14.4, LUSAS scripts can be run from VBS editors which inlcude debugging tools.
' If using V14.4 then uncomment the following line:
'set modeller = GetObject( , "Lusas.Modeller.14.4")	

' Scripts cannot be run from VBS editors in in V14.3. If using V14.3 then comment-out the above line and then 
' uncomment the following line and the ENGINE=VBScript line at top of page (defautl settings here)
' When debugging in VBS editors all references to LUSAS objects should start with 'modeller' e.g. 
' set textWindow = modeller.getTextWindow()
 set modeller = app	
' ----------------------------------------------------------------------------------------------------------




'Check if results are loaded on active loadcase
if modeller.view.hasActivePostLoadset() then 
call PrintBeamFibreStresses()
else
Msgbox "Results not loaded"
end If



Sub PrintBeamFibreStresses()

'Option can be used to include nodal coordinates in results. Set to True if coordinates requried, otherwise set to False
Opt_IncCoor = True
'Option for manual error handling. 
Opt_OnErr = False
if Opt_OnErr then on error resume next

' Get text window handle
set textWindow = modeller.getTextWindow()
	
'Set all visible
modeller.visible.add("All")

'Get array of geometric attributes
GeoArr = modeller.db.getAttributes("Geometric","All")
ubGeoArr = UBound(GeoArr)

	
' open Excel application
set ExcelApp = modeller.CreateAutomationObject("Excel.Application")
	
' set Names of workbook and worksheet (see subroutine below)
Call initialiseExcelApp(ExcelApp, "PrintBeamFibreStresses", "LusasOutput")

' ExcelApp.visible=true
'	ExcelApp.ScreenUpdating = False
	
' get Excel Object
    set WorkBook = ExcelApp.WorkBooks(1)
    set WorkSheet= WorkBook.WorkSheets(1)

Entity = "Stress - Thick 3D Beam"
components = Modeller.view.getResultsComponentNames(Entity)
ubcomponents = ubound(components)

WorkSheet.Cells(1,1) = "Unaveraged element nodal results for thick beams"
RowNo = 2
' number of points
    WorkSheet.Cells(RowNo,1).Value = "Geometric Attribute"
    WorkSheet.Cells(RowNo,2).Value = "Fibre"
    WorkSheet.Cells(RowNo,3).Value = "Element"
    WorkSheet.Cells(RowNo,4).Value = "Node"
	ColNo = 5
	'Result titles
	for j=0 to ubcomponents
	WorkSheet.Cells(RowNo,ColNo).Value = components(j)
	ColNo = ColNo+1
	next

    If Opt_IncCoor Then
    WorkSheet.Cells(RowNo,ColNo).Value = "X"
	ColNo=ColNo+1
    WorkSheet.Cells(RowNo,ColNo).Value = "Y"
	ColNo=ColNo+1
    WorkSheet.Cells(RowNo,ColNo).Value = "Z"
    End If
    
RowNo = RowNo + 1	


		
'Step through geometric attributes
for GeoNo = 0 to ubGeoArr

	'Get names of geometric attributes
	GeoName = GeoArr(GeoNo).getname()
	
	'Get subtype of geometric attributes
	GeoType = GeoArr(GeoNo).getsubtype()
	
	'Get Assignments of each geoemtric attribute
	GeoAsgn = GeoArr(GeoNo).GetAssignments()
	ubGeoAsgn = UBound(GeoAsgn)
	
	'Check if geoemtric attribute assigned
	if ubGeoAsgn<>-1 Then
		
		'Step through each assignment
		For AsgnNo = 0 To ubGeoAsgn
		
			'Get object of assignment (i.e. geometry)
			Set AsgnObj = GeoAsgn(AsgnNo).getDatabaseObject()
			ObjType = AsgnObj.getTypeCode()
			ObjName = AsgnObj.GetName()	
			
			'Get array of current elements on current object
			ElArr = AsgnObj.getElements()
			ubElArr = ubound(ElArr)
			
			'Get type of results for 1st element. Should be same for all elements
			ElType = ElArr(0).getStressType()
			
				'Check if geometric attribute is type '3D Thick Beam'
				if strcomp(ElType, "Thick 3D Beam",1) = 0 then
							 				
					'Get array of fibre names for current geometric attribute
					FibArr = GeoArr(GeoNo).getFibreNames()
					ubFibArr = ubound(FibArr)
						'Step through fibres
						for fibNo = 0 to ubFibArr
						
						'Get name of current fibre
						FibName = FibArr(fibNo)		
						
						'Set current fibre active
						call modeller.view.setActiveFibre(GeoArr(GeoNo), FibName)
						
							'Step through array of visible elements
							for ElNo=0 to ubElArr
							
								'Get ID of current element
								ElID = ElArr(ElNo).getID()
									
								' Get array of nodes for element
								nodeArr = ElArr(ElNo).getnodes()
								ubNodeArr=ubound(nodeArr)
								
								'Step through each node
								for NodeNo = 0 to ubNodeArr
								
									Set nodeobj	= nodeArr(NodeNo)
								
									'Get ID of current node
									NodeID = nodeobj.getID()
																				
									'Write each row of spreadsheet 
								    WorkSheet.Cells(RowNo,1).Value = GeoName
									WorkSheet.Cells(RowNo,2).Value = FibName
									WorkSheet.Cells(RowNo,3).Value = ElID
									WorkSheet.Cells(RowNo,4).Value = NodeID
																		
									ColNo = 5
										for j=0 to ubcomponents
											ResName = components(j)
											ResVal = ElArr(ElNo).getNodeResults(NodeNo,entity, ResName)
											WorkSheet.Cells(RowNo,ColNo).Value = ResVal
											ColNo = ColNo+1
										next
									
									    If Opt_IncCoor Then
									    WorkSheet.Cells(RowNo,ColNo).Value = nodeArr(NodeNo).getX()
										ColNo=ColNo+1
									    WorkSheet.Cells(RowNo,ColNo).Value = nodeArr(NodeNo).getY()
										ColNo=ColNo+1
									    WorkSheet.Cells(RowNo,ColNo).Value = nodeArr(NodeNo).getZ()
									    End If
															
									RowNo = RowNo + 1
								Next
								
							Next
							
						Next
				textwindow.writeline("Stress results outputted to Excel for geometric attribute : " & GeoName & ", on Line " & ObjName)
				
				Else
				textwindow.writeline("The following geometric attribute is not assigned to 3D thick beams and therefore will not be processed : " & GeoName)	
				end If
		next
	Else
		textwindow.writeline("The following geometric attribute has no assignments and therefore will not be processed : " & GeoName)
	End if
next		

WorkSheet.Cells(2,1).EntireRow.AutoFilter
WorkSheet.Cells.EntireColumn.AutoFit
ExcelApp.visible=True
' save Excel work book in default file directory
Fname=getCWD() & "\" & WorkBook.Title + ".xlsx"
WorkBook.SaveAs(Fname)
textWindow.WriteLine("Excel Document " & Fname & " created")
' quit Excel
'  ++ ExcelApp.Quit
textwindow.writeline(" ... Complted ") 

'If Opt_OnErr is true then error handling has been set to default and so Excel needs to be closed automatically
'call ErrorHandle(Opt_OnErr, Err, ExcelApp)
Set AsgnObj = Nothing
Set nodeobj = Nothing
Set ExcelApp = Nothing
set WorkBook = Nothing
set WorkSheet= Nothing
Set textwindow = Nothing

Modeller.db.flushscriptedresults()


end sub


sub initialiseExcelApp(ExcelObj, workBookName, sheetName)
    Const TemporaryFolder = 2
' set file directory as Windows temporary directory
    FSO = CreateObject("Scripting.FileSystemObject").GetSpecialFolder(TemporaryFolder)
	ExcelObj.DefaultFilePath = FSO
' set excel default save directory to working directory of LUSAS model so user can quickly save worksheet if required.
	WorkingDirectory = Modeller.getCWD() & "\" 
	FSO = CreateObject("Scripting.FileSystemObject").GetFolder(WorkingDirectory)
	ExcelObj.DefaultFilePath = FSO
	
' get workbook
    set WB = ExcelObj.WorkBooks.Add
    WB.Title = workBookName
' get worksheet
    set WS = WB.Worksheets(1)
    WS.Name = sheetName
End Sub

Sub ErrorHandle(Opt_OnErr, Err, ExcelApp)
	if Opt_OnErr and Err.number<>0 then
	Ans = Msgbox ("The following error has occured. Error[" & Err.number & "]: " & Err.Description & ". Close Excel?", vbOKCancel)
		if Ans = 1 then
			ExcelApp.WorkBooks(1).Close(False)
			ExcelApp.Quit
		end if
	end if
end sub

