$ENGINE=VBScript
'********************************************************
'* ReformatSRBSprn.vbs Rev 0                            *
'* Created at 12:57 on Friday, April 15 2016            *
'* (C) FEA Ltd 2016                                     *
'* Reformat Slice Resultants for Beams and Shells prn   *
'********************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH*
'* IS NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED  *
'* ON AN AS IS BASIS FOR DEMONSTRATION PURPOSES.        *
'********************************************************
Dim Text, Lineoftext, InfileName, OutfileName, SlicePos, LCPos, LCName, ModelNameWritten, ModNam

ModelNameWritten = 0

' Get text window object
    set tw = getTextWindow()
    tw.writeline("Converting 'SliceResultantsBeamsShells.prn' to csv format...")

'Get current working directory
CWD = GetCWD() 

' set filenames
' Create filepath
  InfileName =  ( CWD & "\SliceResultantsBeamsShells.prn")
  OutfileName = ( CWD &  "\SRBS_reformatted_prn.csv")

  tw.writeline( "Slice Input File: "  & InfileName) 

' open file and write text
     set outFile = newTextFile (OutfileName, TRUE)
     outFile.write "Date:" & Date & " Time: " & Time & vbNewLine

' open file for reading
  set inFile = getTextFileForReading (InfileName)
  Do    While Not inFile.AtEndOfStream
     Lineoftext = inFile.ReadLine
     ModNam = Instr(1, Lineoftext, "Model", 1)
     LCPos = Instr(1, Lineoftext, "Load", 1)
     SlicePos = Instr(1, Lineoftext, "Slice", 1)
' check if the line read has the model name in it and if write the line to the csv  with the column headers following, if it has not already been written
     If ModNam=1 and ModelNameWritten = 0 Then 
        outFile.write Lineoftext & vbNewLine
        outFile.write "Loadcase:, Title, Dist, X, Y, Z, Px, Py, Pz, Mx, My, Mz" & vbNewLine
        ModelNameWritten = 1
     End If
' check if the line read has the loadcase name in it and if so set the variable LCName to the name of the loadcase
     If LCPos=1 Then 
        LCName = Mid(Lineoftext,9)
     End If
' check if the line read has the slice results in it and if so write this date after the loadcase name in the csv file
     If SlicePos>0 Then
' open file and write text
        outFile.write LCName & "," & Lineoftext & vbNewLine
     End If
     set SlicePos = nothing
  Loop

' close prn and csv files
  inFile.close()
  outFile.close()

'Write to the text output window that the script has finished and state the path and filename of the csv created
  tw.writeline("... conversion to csv completed.")
  tw.writeline("Slice Resultants Beams/Shells output saved as: " &  CWD & "\SRBS_reformatted_prn.csv")

Function newTextFile (fileSpec, overwriteExisting)
  set fileSys = CreateObject("Scripting.FileSystemObject")
  set newTextFile = fileSys.CreateTextFile(fileSpec, overwriteExisting)
End Function

Function getTextFileForReading (fileSpec)
  const ForReading = 1
  set fileSys = CreateObject("Scripting.FileSystemObject")
  set getTextFileForReading = fileSys.OpenTextFile(fileSpec, ForReading)
End Function
