$ENGINE=VBScript
'==============================================================================
'* Description:
'* Outputs results components for a 2D slice along a line to aspreadsheet for  
'* the active loadcase and selected lines - intended for beam mesh models
'==============================================================================
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS NOT QUALITY APPROVED 
'* OR SUPPORTED IT IS PROVIDED ON AN AS IS BASIS FOR DEMONSTRATION PURPOSES.
'==============================================================================

  set textWindow = getTextWindow()

  call SectionResults

  set textwindow = nothing

Sub SectionResults

'*** get dataset number at start
  ids =db.getLargestAttributeID("Graph")+1

'*** Load case
  loadcaseID=view.getActiveLoadset().getID
  loadcasename=view.getActiveLoadset().getName

'*** Get current selection object
  set sel = getSelection()

'*** Filter selection for lines only
  lineselected = sel.getObjects("Line", "ALL")

'*** extract number of selected objects
  nobject = selection.count("Line")

'*** loop selected objects to find first line
  for i = 0 to nobject-1

'*** set line object
      set line = lineselected(i)
'*** get array of points defining the lines
      pointsofline  = lineselected(i).getLOFS()
'*** extract number of lower order features (i.e. points)
      npts = Ubound(pointsofline)+1
'*** start and end coordinates
      pointsofline(0).getXYZ X1,Y1,Z1
      pointsofline(1).getXYZ X2,Y2,Z2
'*** line Number
      lineNo=line.getID

'*** output datasets to file

    textwindow.writeline("Starting Results Output to Spreadsheet...")

'*** Lets create an Excel file holding the data and save it under a default name    
'*** open Excel application
    set ExcelApp = CreateAutomationObject("Excel.Application")
'Set the name of the workbook and of the worksheet
    spreadsheetname=db.getDBFilenameNoExtension()&"_Sections_" & LineNo & "_" & LoadcaseID
    WorkSheetName = "Line=" & lineno & " Case=" & loadcaseid   

    '*** set Names of workbook and worksheet
    call initialiseExcelApp(ExcelApp,spreadsheetname,WorkSheetName)

'*** Specify results to be output
      entity="Force/Moment - Thick 2D Beam"
      Redim rcol(60)
      components = view.getResultsComponentNames(entity)
      ncol=Ubound(components)

'*** slice model using line coordinates
      for j = 0 to ncol
         set graphObj = newGraph(1)

'*** Slice using graph through 2D
         graphArray = graphObj.createSliceResults(entity, components(j), x1, y1, x2, y2, " TITLX=(" & x1 & "," & y1 & ") to (" & x2 & "," & y2 & ")"," TITLY=" & rcol(j))
         err = ubound(graphArray) < 1
         call graphObj.close()

         YValues = graphArray(1).getValues()

'*** get Excel Object
      set WorkBook = ExcelApp.WorkBooks(1)
      set WorkSheet= WorkBook.WorkSheets(1)

'*** Enter the distance along the line (X values) only the first time - when j = 0
         If j = 0 Then
            WorkSheet.cells(1,1)="(" & x1 & "," & y1 & ") to (" & x2 & "," & y2 & ")"
            XValues = graphArray(0).getValues()
      
'*** Check datasets output and write to the text output window
'CHOUT            textwindow.writeline("Results extracted for: Line = " & lineno & " and Loadcase = " & loadcaseid)
'CHOUT 
'CHOUT 	    AllXValues = "XValues(0) = " & XValues(0)
'CHOUT             for n=1 to Ubound (XValues)
'CHOUT                AllXValues = AllXValues & ";  XValues(" & n & ") = " &  XValues(n)
'CHOUT                textwindow.writeline(AllXValues)
'CHOUT             Next
'CHOUT             Set n = nothing
'CHOUT 
'CHOUT 	    AllYValues = "YValues(0) = " & YValues(0)
'CHOUT             for n=1 to Ubound (YValues)
'CHOUT                AllYValues = AllYValues & ";  YValues(" & n & ") = " &  YValues(n)
'CHOUT                textwindow.writeline(AllYValues)
'CHOUT             Next 
'CHOUT             Set n = nothing
'CHOUT 
'CHOUT             Set AllXValues = Nothing
'CHOUT             Set AllYValues = Nothing

            for nrow = 2 to UBound(XValues)+2
               If Left(XValues(nrow-2),3) = "1.#" Then 
                  WorkSheet.cells(nrow,1)= "NaN"
               Else
                  WorkSheet.cells(nrow,1)= XValues(nrow-2)
               End If                  
            next
'*** Clear the array of X Values
            Set XValues = Nothing
         Else
         End If

'*** Set up component titles
            WorkSheet.Cells(1,j+2) = components(j)
   
'*** Tabulate results for each component 
            for nrow = 2 to UBound(YValues)+2
               If Left(YValues(nrow-2),4) = "-1.#" Then 
                  WorkSheet.cells(nrow,j+2)= "NaN"
               Else
                  WorkSheet.cells(nrow,j+2)= YValues(nrow-2)
               End IF  
            next

'*** Clear the array of Y Values and for the graph data
         Set YValues = Nothing
         Set graphArray = Nothing

      next  
'*** Close Spreadsheet
      WorkBook.SaveAs(spreadsheetname)  
      ExcelApp.WorkBooks(1).Close  
      ExcelApp.Quit
      textwindow.writeline("...Finished Results Output to Spreadsheet")

      Set ExcelApp = Nothing
      set WorkSheet = Nothing
  next

'*** get dataset number at start
  idf =db.getLargestAttributeID("Graph")

'*** Delete datasets
    Call View.update(1)
    Call db.deleteAttributes("Graph",ids & "T" & idf, false)

End Sub

'*** Setup Excel
Sub initialiseExcelApp(ExcelObj, workBookName, sheetName)
    Const TemporaryFolder = 2
'*** set file directory as Windows temporary directory
    FilePath = CreateObject("Scripting.FileSystemObject").GetSpecialFolder(TemporaryFolder)
    ExcelObj.DefaultFilePath = FilePath
'*** get workbook
    set WB = ExcelObj.WorkBooks.Add
    WB.Title = workBookName
'*** get worksheet
    set WS = WB.Worksheets(1)
    WS.Name = sheetName
End Sub

