$ENGINE=VBScript
'********************************************************************************
'* SetViewNormal.vbs                                 					
'* Created 11/10/2010                             					
'********************************************************************************
' 
'Description for use
'1.	If a user defined local coordinates system has been set active (denoted by a black dot next to the local coordinate name in the Attributes treeview), then set this inactive (right click on the local coordinate name in the attribute treeview and click set active again). 
'2.	Select three points on the surface that you wish to view perpendicularly
'3.	Click File->Script=>Run script and navigate to the script named above. 
'4.	Click OK. The model view should then change.

set modeller = app	
' -----------------------------------------------------------------------------------------------------------------------------------------------------------------------

With modeller
Dim vA(2)
Dim vB(2)
Dim vC(2)

Points = .selection.getobjects("points")
vA(0) = Points(1).getX() - Points(0).getX() 
vA(1) = Points(1).getY() - Points(0).getY() 
vA(2) = Points(1).getZ() - Points(0).getZ() 

vB(0) = Points(2).getX() - Points(0).getX() 
vB(1) = Points(2).getY() - Points(0).getY() 
vB(2) = Points(2).getZ() - Points(0).getZ() 

vN = CrossProduct(vA,vB)

call .view.setRotationVector(vN(0), vN(1), vN(2))
' call .view.panToPosition(Points(0).getX(), Points(0).getY(), Points(0).getZ(), 0.0, 0.0)
call view.setScaledToFit(true)

End with

Function CrossProduct(vA,vB)

vC(0) = vA(1)*vB(2) - vA(2)*vB(1)
vC(1) = -vA(0)*vB(2) + vA(2)*vB(0)
vC(2) = vA(0)*vB(1) - vA(1)*vB(0)

CrossProduct = vC

End function